/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.util;

import org.apache.commons.lang.StringUtils;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationTypeDetermer<T, U extends T> {
    private final ModelType<U> baseImplementation;
    private String modelName;

    public ImplementationTypeDetermer(String modelName, Class<U> baseImplementation) {
        this.modelName = modelName;
        this.baseImplementation = ModelType.of(baseImplementation);
    }

    public ModelType<? extends U> determineImplementationType(ModelType<? extends T> type, TypeBuilderInternal<? extends T> builder) {
        Class<? extends T> implementation = builder.getDefaultImplementation();
        if (implementation == null) {
            return null;
        }
        ModelType implementationType = ModelType.of(implementation);
        ModelType asSubclass = this.baseImplementation.asSubclass(implementationType);
        if (asSubclass == null) {
            throw new InvalidModelException(String.format("%s implementation '%s' must extend '%s'.", StringUtils.capitalize((String)this.modelName), implementationType, this.baseImplementation));
        }
        if (!type.isAssignableFrom(asSubclass)) {
            throw new InvalidModelException(String.format("%s implementation '%s' must implement '%s'.", StringUtils.capitalize((String)this.modelName), asSubclass, type));
        }
        try {
            asSubclass.getRawClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException nsmException) {
            throw new InvalidModelException(String.format("%s implementation '%s' must have public default constructor.", StringUtils.capitalize((String)this.modelName), asSubclass));
        }
        return asSubclass;
    }
}

