/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.util.BiFunction;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.internal.core.AbstractModelActionWithView;
import org.gradle.model.internal.core.ExtractedModelAction;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.component.BaseComponentSpec;
import org.gradle.platform.base.internal.ComponentSpecFactory;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;
import org.gradle.platform.base.internal.builder.TypeBuilderFactory;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;
import org.gradle.platform.base.internal.registry.AbstractTypeBuilder;
import org.gradle.platform.base.internal.registry.TypeModelRuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTypeModelRuleExtractor
extends TypeModelRuleExtractor<ComponentType, ComponentSpec, BaseComponentSpec> {
    public ComponentTypeModelRuleExtractor(ModelSchemaStore schemaStore) {
        super("component", ComponentSpec.class, BaseComponentSpec.class, ComponentTypeBuilder.class, schemaStore, new TypeBuilderFactory<ComponentSpec>(){

            @Override
            public TypeBuilderInternal<ComponentSpec> create(ModelSchema<? extends ComponentSpec> schema) {
                return new DefaultComponentTypeBuilder(schema);
            }
        });
    }

    @Override
    protected <R, S> ExtractedModelRule createRegistration(MethodRuleDefinition<R, S> ruleDefinition, ModelType<? extends ComponentSpec> type, TypeBuilderInternal<ComponentSpec> builder) {
        ImmutableList dependencies = ImmutableList.of(ComponentModelBasePlugin.class);
        ModelType implementation = this.determineImplementationType(type, builder);
        RegistrationAction mutator = new RegistrationAction(type, implementation, builder.getInternalViews(), ruleDefinition.getDescriptor());
        return new ExtractedModelAction(ModelActionRole.Defaults, (List)dependencies, (ModelAction)mutator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistrationAction
    extends AbstractModelActionWithView<ComponentSpecFactory> {
        private static final ModelType<ComponentSpecInternal> COMPONENT_SPEC_INTERNAL_MODEL_TYPE = ModelType.of(ComponentSpecInternal.class);
        private final ModelType<? extends ComponentSpec> publicType;
        private final ModelType<? extends BaseComponentSpec> implementationType;
        private final Set<Class<?>> internalViews;

        public RegistrationAction(ModelType<? extends ComponentSpec> publicType, ModelType<? extends BaseComponentSpec> implementationType, Set<Class<?>> internalViews, ModelRuleDescriptor descriptor) {
            super(ModelReference.of(ComponentSpecFactory.class), descriptor, new ModelReference[]{ModelReference.of(ServiceRegistry.class), ModelReference.of(ProjectIdentifier.class), ModelReference.of(ProjectSourceSet.class)});
            this.publicType = publicType;
            this.implementationType = implementationType;
            this.internalViews = internalViews;
        }

        protected void execute(MutableModelNode modelNode, ComponentSpecFactory components, List<ModelView<?>> inputs) {
            if (this.implementationType != null) {
                this.registerImplementation(components, inputs);
            }
            for (Class<?> internalView : this.internalViews) {
                components.registerInternalView(this.publicType, this.descriptor, ModelType.of(internalView));
            }
        }

        private <T extends ComponentSpec> void registerImplementation(ComponentSpecFactory components, List<ModelView<?>> inputs) {
            ServiceRegistry serviceRegistry = (ServiceRegistry)ModelViews.assertType(inputs.get(0), (ModelType)ModelType.of(ServiceRegistry.class)).getInstance();
            final Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            final ProjectIdentifier projectIdentifier = (ProjectIdentifier)ModelViews.assertType(inputs.get(1), (ModelType)ModelType.of(ProjectIdentifier.class)).getInstance();
            final ProjectSourceSet projectSourceSet = (ProjectSourceSet)ModelViews.assertType(inputs.get(2), (ModelType)ModelType.of(ProjectSourceSet.class)).getInstance();
            components.registerFactory((ModelType)Cast.uncheckedCast(this.publicType), this.descriptor, (BiFunction)new BiFunction<ComponentSpec, String, MutableModelNode>(){

                public ComponentSpec apply(String name, MutableModelNode modelNode) {
                    DefaultComponentSpecIdentifier id = new DefaultComponentSpecIdentifier(projectIdentifier.getPath(), name);
                    return BaseComponentSpec.create(RegistrationAction.this.implementationType.getConcreteClass(), id, modelNode, projectSourceSet, instantiator);
                }
            });
            components.registerImplementation((ModelType)Cast.uncheckedCast(this.publicType), this.descriptor, (ModelType)Cast.uncheckedCast(this.implementationType));
            if (COMPONENT_SPEC_INTERNAL_MODEL_TYPE.isAssignableFrom(this.implementationType)) {
                components.registerInternalView(this.publicType, this.descriptor, COMPONENT_SPEC_INTERNAL_MODEL_TYPE);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultComponentTypeBuilder
    extends AbstractTypeBuilder<ComponentSpec>
    implements ComponentTypeBuilder<ComponentSpec> {
        public DefaultComponentTypeBuilder(ModelSchema<? extends ComponentSpec> schema) {
            super(ComponentType.class, schema);
        }
    }
}

