/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import java.util.Iterator;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.rules.ModelMapCreators;
import org.gradle.api.internal.rules.NamedDomainObjectFactoryRegistry;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.util.BiFunction;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.model.BinarySpecFactoryRegistry;
import org.gradle.language.base.internal.model.ComponentBinaryRules;
import org.gradle.language.base.internal.model.ComponentRules;
import org.gradle.language.base.internal.registry.DefaultLanguageRegistry;
import org.gradle.language.base.internal.registry.DefaultLanguageTransformContainer;
import org.gradle.language.base.internal.registry.LanguageRegistry;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.Validate;
import org.gradle.model.internal.core.DefaultInstanceFactoryRegistry;
import org.gradle.model.internal.core.InstanceFactoryRegistry;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.SpecializedMapSchema;
import org.gradle.model.internal.manage.schema.extract.FactoryBasedNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.internal.BinarySpecFactory;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecAware;
import org.gradle.platform.base.internal.ComponentSpecFactory;
import org.gradle.platform.base.internal.DefaultPlatformContainer;
import org.gradle.platform.base.internal.DefaultPlatformResolvers;
import org.gradle.platform.base.internal.PlatformResolvers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class ComponentModelBasePlugin
implements Plugin<ProjectInternal> {
    private final ModelRegistry modelRegistry;
    private final ModelSchemaStore schemaStore;

    @Inject
    public ComponentModelBasePlugin(ModelRegistry modelRegistry, ModelSchemaStore schemaStore) {
        this.modelRegistry = modelRegistry;
        this.schemaStore = schemaStore;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LanguageBasePlugin.class);
        SimpleModelRuleDescriptor descriptor = new SimpleModelRuleDescriptor(ComponentModelBasePlugin.class.getSimpleName() + ".apply()");
        SpecializedMapSchema schema = (SpecializedMapSchema)this.schemaStore.getSchema(ModelType.of(ComponentSpecContainer.class));
        ModelPath components = ModelPath.path((String)"components");
        ModelCreator componentsCreator = ModelMapCreators.specialized((ModelPath)components, ComponentSpec.class, ComponentSpecContainer.class, schema.getImplementationType().asSubclass(ComponentSpecContainer.class), (ModelRuleDescriptor)descriptor);
        this.modelRegistry.create(componentsCreator);
        this.modelRegistry.getRoot().applyToAllLinksTransitive(ModelType.of(ComponentSpec.class), ComponentRules.class);
        this.modelRegistry.getRoot().applyToAllLinksTransitive(ModelType.of(ComponentSpec.class), ComponentBinaryRules.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        ComponentSpecFactory componentSpecFactory() {
            return new ComponentSpecFactory("this collection");
        }

        @Mutate
        void registerNodeInitializerExtractors(NodeInitializerRegistry nodeInitializerRegistry, InstanceFactoryRegistry instanceFactoryRegistry) {
            nodeInitializerRegistry.registerStrategy((NodeInitializerExtractionStrategy)new FactoryBasedNodeInitializerExtractionStrategy(instanceFactoryRegistry));
        }

        @Model
        LanguageRegistry languages(ServiceRegistry serviceRegistry) {
            return (LanguageRegistry)((Instantiator)serviceRegistry.get(Instantiator.class)).newInstance(DefaultLanguageRegistry.class, new Object[0]);
        }

        @Model
        LanguageTransformContainer languageTransforms(ServiceRegistry serviceRegistry) {
            return (LanguageTransformContainer)((Instantiator)serviceRegistry.get(Instantiator.class)).newInstance(DefaultLanguageTransformContainer.class, new Object[0]);
        }

        @Mutate
        void closeComponentsForBinaries(ModelMap<Task> tasks, ComponentSpecContainer components) {
        }

        @Finalize
        void createSourceTransformTasks(TaskContainer tasks, BinaryContainer binaries, LanguageTransformContainer languageTransforms, ServiceRegistry serviceRegistry) {
            Iterator i$ = languageTransforms.iterator();
            while (i$.hasNext()) {
                LanguageTransform language = (LanguageTransform)i$.next();
                for (BinarySpecInternal binary : binaries.withType(BinarySpecInternal.class)) {
                    if (binary.isLegacyBinary() || !language.applyToBinary(binary)) continue;
                    SourceTransformTaskConfig taskConfig = language.getTransformTask();
                    for (LanguageSourceSet languageSourceSet : binary.getInputs()) {
                        LanguageSourceSetInternal sourceSet = (LanguageSourceSetInternal)languageSourceSet;
                        if (!language.getSourceSetType().isInstance(sourceSet) || !sourceSet.getMayHaveSources()) continue;
                        String taskName = taskConfig.getTaskPrefix() + StringUtils.capitalize((String)binary.getName()) + StringUtils.capitalize((String)sourceSet.getFullName());
                        Task task = tasks.create(taskName, taskConfig.getTaskType());
                        taskConfig.configureTask(task, binary, sourceSet, serviceRegistry);
                        task.dependsOn(new Object[]{sourceSet});
                        binary.getTasks().add(task);
                    }
                }
            }
        }

        @Model
        PlatformContainer platforms(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (PlatformContainer)instantiator.newInstance(DefaultPlatformContainer.class, new Object[]{instantiator});
        }

        @Model
        PlatformResolvers platformResolver(PlatformContainer platforms, ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (PlatformResolvers)instantiator.newInstance(DefaultPlatformResolvers.class, new Object[]{platforms});
        }

        @Mutate
        void registerPlatformExtension(ExtensionContainer extensions, PlatformContainer platforms) {
            extensions.add("platforms", (Object)platforms);
        }

        @Model
        BinarySpecFactory binarySpecFactory(BinarySpecFactoryRegistry binaryFactoryRegistry) {
            final BinarySpecFactory binarySpecFactory = new BinarySpecFactory("this collection");
            binaryFactoryRegistry.copyInto(new NamedDomainObjectFactoryRegistry<BinarySpec>(){

                public <U extends BinarySpec> void registerFactory(Class<U> type, final NamedDomainObjectFactory<? extends U> factory) {
                    binarySpecFactory.registerFactory(ModelType.of(type), null, new BiFunction<U, String, MutableModelNode>(){

                        public U apply(String s, MutableModelNode modelNode) {
                            BinarySpec binarySpec = (BinarySpec)factory.create(s);
                            Object parentObject = modelNode.getParent().getParent().getPrivateData();
                            if (parentObject instanceof ComponentSpec && binarySpec instanceof ComponentSpecAware) {
                                ((ComponentSpecAware)((Object)binarySpec)).setComponent((ComponentSpec)parentObject);
                            }
                            return binarySpec;
                        }
                    });
                }
            });
            return binarySpecFactory;
        }

        @Model
        InstanceFactoryRegistry instanceFactoryRegistry(ServiceRegistry serviceRegistry, BinarySpecFactory binarySpecFactory, @Path(value="componentSpecFactory") ComponentSpecFactory componentSpecFactory) {
            DefaultInstanceFactoryRegistry instanceFactoryRegistry = new DefaultInstanceFactoryRegistry();
            for (ModelType type : binarySpecFactory.getSupportedTypes()) {
                instanceFactoryRegistry.register(type, ModelReference.of(BinarySpecFactory.class));
            }
            for (ModelType type : componentSpecFactory.getSupportedTypes()) {
                instanceFactoryRegistry.register(type, ModelReference.of(ComponentSpecFactory.class));
            }
            return instanceFactoryRegistry;
        }

        @Defaults
        void collectBinaries(BinaryContainer binaries, ComponentSpecContainer componentSpecs) {
            for (ComponentSpec componentSpec : componentSpecs.values()) {
                for (BinarySpec binary : componentSpec.getBinaries().values()) {
                    binaries.add(binary);
                }
            }
        }

        @Validate
        void validateComponentSpecInternalViews(ComponentSpecFactory componentSpecFactory) {
            componentSpecFactory.validateRegistrations();
        }

        @Finalize
        void addSourceSetsOwnedByBinariesToTheirInputs(BinaryContainer binarySpecs) {
            Iterator i$ = binarySpecs.iterator();
            while (i$.hasNext()) {
                BinarySpec binary = (BinarySpec)i$.next();
                if (((BinarySpecInternal)binary).isLegacyBinary()) continue;
                binary.getInputs().addAll(binary.getSources().values());
            }
        }
    }
}

