/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.resolve;

import com.google.common.base.Strings;
import java.util.Collections;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.LocalComponentConverter;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.LocalComponentDependencyMetaData;
import org.gradle.language.base.internal.DependentSourceSetInternal;
import org.gradle.language.base.internal.model.DefaultLibraryLocalComponentMetaData;
import org.gradle.language.base.internal.resolve.DependentSourceSetResolveContext;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.DependencySpecContainer;

public class DependentSourceSetLocalComponentConverter
implements LocalComponentConverter {
    private static final ExcludeRule[] EXCLUDE_RULES = new ExcludeRule[0];

    public boolean canConvert(Object source) {
        return source instanceof DependentSourceSetResolveContext;
    }

    public DefaultLibraryLocalComponentMetaData convert(Object source) {
        DependentSourceSetResolveContext context = (DependentSourceSetResolveContext)source;
        LibraryBinaryIdentifier libraryBinaryIdentifier = context.getComponentId();
        DependentSourceSetInternal sourceSet = context.getSourceSet();
        TaskDependency buildDependencies = context.getSourceSet().getBuildDependencies();
        DefaultLibraryLocalComponentMetaData metaData = DefaultLibraryLocalComponentMetaData.newMetaData(libraryBinaryIdentifier, buildDependencies);
        this.addDependencies(libraryBinaryIdentifier.getProjectPath(), metaData, sourceSet.getDependencies());
        return metaData;
    }

    private void addDependencies(String defaultProject, DefaultLocalComponentMetaData metaData, DependencySpecContainer allDependencies) {
        ModuleVersionIdentifier mvi = metaData.getId();
        for (DependencySpec dependency : allDependencies.getDependencies()) {
            String projectPath = dependency.getProjectPath();
            if (Strings.isNullOrEmpty((String)projectPath)) {
                projectPath = defaultProject;
            }
            String libraryName = dependency.getLibraryName();
            DefaultLibraryComponentSelector selector = new DefaultLibraryComponentSelector(projectPath, libraryName);
            DefaultModuleVersionSelector requested = new DefaultModuleVersionSelector(Strings.nullToEmpty((String)projectPath), Strings.nullToEmpty((String)libraryName), mvi.getVersion());
            LocalComponentDependencyMetaData localComponentDependencyMetaData = new LocalComponentDependencyMetaData((ComponentSelector)selector, (ModuleVersionSelector)requested, "Component configuration", "Component configuration", Collections.emptySet(), EXCLUDE_RULES, false, false, true);
            metaData.addDependency((DependencyMetaData)localComponentDependencyMetaData);
        }
    }
}

