/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.model;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.language.base.internal.model.VariantsMetaData;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ModelStructSchema;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.VariantAspect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVariantsMetaData
implements VariantsMetaData {
    private final Map<String, Object> variants;
    private final Set<String> allVariantDimensions;
    private final Set<String> nonNullVariantDimensions;
    private final Map<String, ModelType<?>> variantDimensionTypes;

    private DefaultVariantsMetaData(Map<String, Object> variants, Map<String, ModelType<?>> variantDimensionTypes) {
        this.variants = variants;
        this.allVariantDimensions = variants.keySet();
        this.nonNullVariantDimensions = ImmutableSet.copyOf(Maps.filterEntries(variants, (Predicate)new Predicate<Map.Entry<String, Object>>(){

            public boolean apply(Map.Entry<String, Object> input) {
                return input.getValue() != null;
            }
        }).keySet());
        this.variantDimensionTypes = variantDimensionTypes;
    }

    public static VariantsMetaData extractFrom(BinarySpec spec, ModelSchemaStore schemaStore) {
        VariantAspect variantAspect;
        LinkedHashMap variants = Maps.newLinkedHashMap();
        ImmutableMap.Builder dimensionTypesBuilder = ImmutableMap.builder();
        ModelSchema schema = schemaStore.getSchema(((BinarySpecInternal)spec).getPublicType());
        if (schema instanceof ModelStructSchema && (variantAspect = (VariantAspect)((ModelStructSchema)schema).getAspect(VariantAspect.class)) != null) {
            for (ModelProperty<?> property : variantAspect.getDimensions()) {
                Object value = property.getPropertyValue((Object)spec);
                variants.put(property.getName(), value);
                dimensionTypesBuilder.put((Object)property.getName(), (Object)property.getType());
            }
        }
        return new DefaultVariantsMetaData(Collections.unmodifiableMap(variants), (Map<String, ModelType<?>>)dimensionTypesBuilder.build());
    }

    @Override
    public Set<String> getAllDimensions() {
        return this.allVariantDimensions;
    }

    @Override
    public Set<String> getNonNullDimensions() {
        return this.nonNullVariantDimensions;
    }

    @Override
    public String getValueAsString(String dimension) {
        Object o = this.variants.get(dimension);
        if (o instanceof Named) {
            return ((Named)o).getName();
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o == null ? null : o.toString();
    }

    @Override
    public <T extends Named> T getValueAsType(Class<T> clazz, String dimension) {
        return (T)((Named)this.variants.get(dimension));
    }

    @Override
    public ModelType<?> getDimensionType(String dimension) {
        return this.variantDimensionTypes.get(dimension);
    }
}

