/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.LibrarySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface LibraryResolutionErrorMessageBuilder {
    public String multipleBinariesForSameVariantErrorMessage(String var1, Collection<? extends BinarySpec> var2);

    public String noCompatibleBinaryErrorMessage(String var1, Collection<BinarySpec> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LibraryResolutionResult {
        private static final LibraryResolutionResult EMPTY = new LibraryResolutionResult();
        private static final LibraryResolutionResult PROJECT_NOT_FOUND = new LibraryResolutionResult();
        private final Map<String, LibrarySpec> libsMatchingRequirements = Maps.newHashMap();
        private final Map<String, LibrarySpec> libsNotMatchingRequirements = Maps.newHashMap();
        private LibrarySpec selectedLibrary;
        private LibrarySpec nonMatchingLibrary;

        private LibraryResolutionResult() {
        }

        private LibrarySpec getSingleMatchingLibrary() {
            if (this.libsMatchingRequirements.size() == 1) {
                return this.libsMatchingRequirements.values().iterator().next();
            }
            return null;
        }

        private void resolve(String libraryName) {
            if (libraryName == null) {
                LibrarySpec singleMatchingLibrary = this.getSingleMatchingLibrary();
                if (singleMatchingLibrary == null) {
                    return;
                }
                libraryName = singleMatchingLibrary.getName();
            }
            this.selectedLibrary = this.libsMatchingRequirements.get(libraryName);
            this.nonMatchingLibrary = this.libsNotMatchingRequirements.get(libraryName);
        }

        public boolean isProjectNotFound() {
            return PROJECT_NOT_FOUND == this;
        }

        public boolean hasLibraries() {
            return !this.libsMatchingRequirements.isEmpty() || !this.libsNotMatchingRequirements.isEmpty();
        }

        public LibrarySpec getSelectedLibrary() {
            return this.selectedLibrary;
        }

        public LibrarySpec getNonMatchingLibrary() {
            return this.nonMatchingLibrary;
        }

        public List<String> getCandidateLibraries() {
            return Lists.newArrayList(this.libsMatchingRequirements.keySet());
        }

        public String toResolutionErrorMessage(Class<? extends BinarySpec> binaryType, LibraryComponentSelector selector) {
            List<String> candidateLibraries = LibraryResolutionResult.formatLibraryNames(this.getCandidateLibraries());
            String projectPath = selector.getProjectPath();
            String libraryName = selector.getLibraryName();
            StringBuilder sb = new StringBuilder("Project '").append(projectPath).append("'");
            if (libraryName == null || !this.hasLibraries()) {
                if (this.isProjectNotFound()) {
                    sb.append(" not found.");
                } else if (!this.hasLibraries()) {
                    sb.append(" doesn't define any library.");
                } else {
                    sb.append(" contains more than one library. Please select one of ");
                    Joiner.on((String)", ").appendTo(sb, candidateLibraries);
                }
            } else {
                LibrarySpec notMatchingRequirements = this.getNonMatchingLibrary();
                if (notMatchingRequirements != null) {
                    sb.append(" contains a library named '").append(libraryName).append("' but it doesn't have any binary of type ").append(binaryType.getSimpleName());
                } else {
                    sb.append(" does not contain library '").append(libraryName).append("'. Did you want to use ");
                    if (candidateLibraries.size() == 1) {
                        sb.append(candidateLibraries.get(0));
                    } else {
                        sb.append("one of ");
                        Joiner.on((String)", ").appendTo(sb, candidateLibraries);
                    }
                    sb.append("?");
                }
            }
            return sb.toString();
        }

        public static LibraryResolutionResult of(Collection<? extends LibrarySpec> libraries, String libraryName, Predicate<? super LibrarySpec> libraryFilter) {
            LibraryResolutionResult result = new LibraryResolutionResult();
            for (LibrarySpec librarySpec : libraries) {
                if (libraryFilter.apply((Object)librarySpec)) {
                    result.libsMatchingRequirements.put(librarySpec.getName(), librarySpec);
                    continue;
                }
                result.libsNotMatchingRequirements.put(librarySpec.getName(), librarySpec);
            }
            result.resolve(libraryName);
            return result;
        }

        public static LibraryResolutionResult projectNotFound() {
            return PROJECT_NOT_FOUND;
        }

        public static LibraryResolutionResult emptyResolutionResult() {
            return EMPTY;
        }

        private static List<String> formatLibraryNames(List<String> libs) {
            List list = Lists.transform(libs, (Function)new Function<String, String>(){

                public String apply(String input) {
                    return String.format("'%s'", input);
                }
            });
            return Ordering.natural().sortedCopy((Iterable)list);
        }
    }
}

