/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.artifact;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.DefaultMavenArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenArtifactNotationParserFactory
implements Factory<NotationParser<Object, MavenArtifact>> {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;

    public MavenArtifactNotationParserFactory(Instantiator instantiator, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
    }

    public NotationParser<Object, MavenArtifact> create() {
        FileNotationConverter fileNotationConverter = new FileNotationConverter(this.fileResolver);
        ArchiveTaskNotationConverter archiveTaskNotationConverter = new ArchiveTaskNotationConverter();
        PublishArtifactNotationConverter publishArtifactNotationConverter = new PublishArtifactNotationConverter();
        NotationParser sourceNotationParser = NotationParserBuilder.toType(MavenArtifact.class).fromType(AbstractArchiveTask.class, (NotationConverter)archiveTaskNotationConverter).fromType(PublishArtifact.class, (NotationConverter)publishArtifactNotationConverter).converter((NotationConverter)fileNotationConverter).toComposite();
        MavenArtifactMapNotationConverter mavenArtifactMapNotationConverter = new MavenArtifactMapNotationConverter(sourceNotationParser);
        NotationParserBuilder parserBuilder = NotationParserBuilder.toType(MavenArtifact.class).fromType(AbstractArchiveTask.class, (NotationConverter)archiveTaskNotationConverter).fromType(PublishArtifact.class, (NotationConverter)publishArtifactNotationConverter).converter((NotationConverter)mavenArtifactMapNotationConverter).converter((NotationConverter)fileNotationConverter);
        return parserBuilder.toComposite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MavenArtifactMapNotationConverter
    extends MapNotationConverter<MavenArtifact> {
        private final NotationParser<Object, MavenArtifact> sourceNotationParser;

        private MavenArtifactMapNotationConverter(NotationParser<Object, MavenArtifact> sourceNotationParser) {
            this.sourceNotationParser = sourceNotationParser;
        }

        protected MavenArtifact parseMap(@MapKey(value="source") Object source) {
            return (MavenArtifact)this.sourceNotationParser.parseNotation(source);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps containing a 'source' entry").example("[source: '/path/to/file', extension: 'zip']");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileNotationConverter
    implements NotationConverter<Object, MavenArtifact> {
        private final NotationParser<Object, File> fileResolverNotationParser;

        private FileNotationConverter(FileResolver fileResolver) {
            this.fileResolverNotationParser = fileResolver.asNotationParser();
        }

        public void convert(Object notation, NotationConvertResult<? super MavenArtifact> result) throws TypeConversionException {
            File file = (File)this.fileResolverNotationParser.parseNotation(notation);
            result.converted((Object)this.parseFile(file));
        }

        protected MavenArtifact parseFile(File file) {
            String extension = StringUtils.substringAfterLast((String)file.getName(), (String)".");
            return (MavenArtifact)MavenArtifactNotationParserFactory.this.instantiator.newInstance(DefaultMavenArtifact.class, new Object[]{file, extension, null});
        }

        public void describe(DiagnosticsVisitor visitor) {
            this.fileResolverNotationParser.describe(visitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PublishArtifactNotationConverter
    implements NotationConverter<PublishArtifact, MavenArtifact> {
        private PublishArtifactNotationConverter() {
        }

        public void convert(PublishArtifact publishArtifact, NotationConvertResult<? super MavenArtifact> result) throws TypeConversionException {
            DefaultMavenArtifact artifact = (DefaultMavenArtifact)MavenArtifactNotationParserFactory.this.instantiator.newInstance(DefaultMavenArtifact.class, new Object[]{publishArtifact.getFile(), publishArtifact.getExtension(), publishArtifact.getClassifier()});
            artifact.builtBy(publishArtifact.getBuildDependencies());
            result.converted((Object)artifact);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of PublishArtifact");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArchiveTaskNotationConverter
    implements NotationConverter<AbstractArchiveTask, MavenArtifact> {
        private ArchiveTaskNotationConverter() {
        }

        public void convert(AbstractArchiveTask archiveTask, NotationConvertResult<? super MavenArtifact> result) throws TypeConversionException {
            DefaultMavenArtifact artifact = (DefaultMavenArtifact)MavenArtifactNotationParserFactory.this.instantiator.newInstance(DefaultMavenArtifact.class, new Object[]{archiveTask.getArchivePath(), archiveTask.getExtension(), archiveTask.getClassifier()});
            artifact.builtBy(archiveTask);
            result.converted((Object)artifact);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of AbstractArchiveTask").example("jar");
        }
    }
}

