/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.List;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.DaemonExpirationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private Iterable<DaemonExpirationStrategy> expirationStrategies;

    public AnyDaemonExpirationStrategy(List<DaemonExpirationStrategy> expirationStrategies) {
        this.expirationStrategies = expirationStrategies;
    }

    @Override
    public DaemonExpirationResult checkExpiration(Daemon daemon) {
        for (DaemonExpirationStrategy expirationStrategy : this.expirationStrategies) {
            DaemonExpirationResult expirationResult = expirationStrategy.checkExpiration(daemon);
            if (!expirationResult.isExpired()) continue;
            return expirationResult;
        }
        return new DaemonExpirationResult(false, null);
    }
}

