/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.connection;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.api.logging.LogLevel;
import org.gradle.tooling.internal.adapter.CompatibleIntrospector;
import org.gradle.tooling.internal.protocol.BuildOperationParametersVersion1;
import org.gradle.tooling.internal.protocol.InternalLaunchable;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;
import org.gradle.tooling.internal.provider.connection.BuildLogLevelMixIn;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptedOperationParameters
implements ProviderOperationParameters {
    private final BuildOperationParametersVersion1 delegate;
    private final List<String> tasks;
    CompatibleIntrospector introspector;

    public AdaptedOperationParameters(BuildOperationParametersVersion1 operationParameters) {
        this(operationParameters, null);
    }

    public AdaptedOperationParameters(BuildOperationParametersVersion1 delegate, List<String> tasks) {
        this.delegate = delegate;
        this.introspector = new CompatibleIntrospector((Object)delegate);
        this.tasks = tasks == null ? null : new LinkedList<String>(tasks);
    }

    @Override
    public InputStream getStandardInput(InputStream defaultInput) {
        return this.maybeGet(defaultInput, "getStandardInput");
    }

    @Override
    public LogLevel getBuildLogLevel() {
        return new BuildLogLevelMixIn(this).getBuildLogLevel();
    }

    @Override
    public boolean getVerboseLogging(boolean defaultValue) {
        return (Boolean)this.introspector.getSafely((Object)defaultValue, "getVerboseLogging");
    }

    @Override
    public File getJavaHome(File defaultJavaHome) {
        return this.maybeGet(defaultJavaHome, "getJavaHome");
    }

    @Override
    public List<String> getJvmArguments(List<String> defaultJvmArgs) {
        return this.maybeGet(defaultJvmArgs, "getJvmArguments");
    }

    private <T> T maybeGet(T defaultValue, String methodName) {
        Object out = this.introspector.getSafely(defaultValue, methodName);
        if (out == null) {
            return defaultValue;
        }
        return (T)out;
    }

    @Override
    public File getProjectDir() {
        return this.delegate.getProjectDir();
    }

    @Override
    public Boolean isSearchUpwards() {
        return this.delegate.isSearchUpwards();
    }

    @Override
    public File getGradleUserHomeDir() {
        return this.delegate.getGradleUserHomeDir();
    }

    @Override
    public Boolean isEmbedded() {
        return this.delegate.isEmbedded();
    }

    @Override
    public Integer getDaemonMaxIdleTimeValue() {
        return this.delegate.getDaemonMaxIdleTimeValue();
    }

    @Override
    public TimeUnit getDaemonMaxIdleTimeUnits() {
        return this.delegate.getDaemonMaxIdleTimeUnits();
    }

    @Override
    public long getStartTime() {
        return this.delegate.getStartTime();
    }

    @Override
    public OutputStream getStandardOutput() {
        return this.delegate.getStandardOutput();
    }

    @Override
    public OutputStream getStandardError() {
        return this.delegate.getStandardError();
    }

    @Override
    public ProgressListenerVersion1 getProgressListener() {
        return this.delegate.getProgressListener();
    }

    @Override
    public List<String> getArguments(List<String> defaultArguments) {
        return this.maybeGet(defaultArguments, "getArguments");
    }

    @Override
    public List<String> getTasks() {
        return this.tasks;
    }

    @Override
    public List<InternalLaunchable> getLaunchables() {
        return this.maybeGet(null, "getLaunchables");
    }
}

