/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import com.google.common.collect.MapMaker;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.tooling.internal.provider.ClassLoaderDetails;
import org.gradle.tooling.internal.provider.DeserializeMap;
import org.gradle.tooling.internal.provider.ModelClassLoaderFactory;
import org.gradle.tooling.internal.provider.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.SerializeMap;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultPayloadClassLoaderRegistry
implements PayloadClassLoaderRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPayloadClassLoaderRegistry.class);
    private final Lock lock = new ReentrantLock();
    private final ModelClassLoaderFactory classLoaderFactory;
    private Map<ClassLoader, ClassLoaderDetails> classLoaderDetails = new MapMaker().weakKeys().makeMap();
    private Map<UUID, ClassLoader> classLoaderIds = new MapMaker().weakValues().makeMap();

    public DefaultPayloadClassLoaderRegistry(ModelClassLoaderFactory modelClassLoaderFactory) {
        this.classLoaderFactory = modelClassLoaderFactory;
    }

    public SerializeMap newSerializeSession() {
        return new SerializeMap(){
            final Map<ClassLoader, Short> classLoaderIds = new HashMap<ClassLoader, Short>();
            final Map<Short, ClassLoaderDetails> classLoaderDetails = new HashMap<Short, ClassLoaderDetails>();

            @Override
            public short visitClass(Class<?> target) {
                ClassLoader classLoader = target.getClassLoader();
                Short id = this.classLoaderIds.get(classLoader);
                if (id != null) {
                    return id;
                }
                if (this.classLoaderIds.size() == Short.MAX_VALUE) {
                    throw new UnsupportedOperationException();
                }
                ClassLoaderDetails details = DefaultPayloadClassLoaderRegistry.this.getDetails(classLoader);
                id = (short)(this.classLoaderIds.size() + 1);
                this.classLoaderIds.put(classLoader, id);
                this.classLoaderDetails.put(id, details);
                return id;
            }

            @Override
            public Map<Short, ClassLoaderDetails> getClassLoaders() {
                return this.classLoaderDetails;
            }
        };
    }

    public DeserializeMap newDeserializeSession() {
        return new DeserializeMap(){

            @Override
            public Class<?> resolveClass(ClassLoaderDetails classLoaderDetails, String className) throws ClassNotFoundException {
                ClassLoader classLoader = DefaultPayloadClassLoaderRegistry.this.getClassLoader(classLoaderDetails);
                return Class.forName(className, false, classLoader);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader(ClassLoaderDetails details) {
        this.lock.lock();
        try {
            ClassLoader classLoader = this.classLoaderIds.get(details.uuid);
            if (classLoader != null) {
                ClassLoader classLoader2 = classLoader;
                return classLoader2;
            }
            ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>();
            for (ClassLoaderDetails parentDetails : details.parents) {
                parents.add(this.getClassLoader(parentDetails));
            }
            if (parents.isEmpty()) {
                parents.add(this.classLoaderFactory.getClassLoaderFor(ClassLoaderSpec.SYSTEM_CLASS_LOADER, null));
            }
            LOGGER.info("Creating ClassLoader {} from {} and {}.", new Object[]{details.uuid, details.spec, parents});
            classLoader = this.classLoaderFactory.getClassLoaderFor(details.spec, parents);
            this.classLoaderIds.put(details.uuid, classLoader);
            this.classLoaderDetails.put(classLoader, details);
            ClassLoader classLoader3 = classLoader;
            return classLoader3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoaderDetails getDetails(ClassLoader classLoader) {
        this.lock.lock();
        try {
            ClassLoaderDetails details = this.classLoaderDetails.get(classLoader);
            if (details != null) {
                ClassLoaderDetails classLoaderDetails = details;
                return classLoaderDetails;
            }
            ClassLoaderSpecVisitor visitor = new ClassLoaderSpecVisitor(classLoader);
            visitor.visit(classLoader);
            if (visitor.spec == null) {
                visitor.spec = visitor.classPath == null ? ClassLoaderSpec.SYSTEM_CLASS_LOADER : new MutableURLClassLoader.Spec(CollectionUtils.toList(visitor.classPath));
            }
            UUID uuid = UUID.randomUUID();
            details = new ClassLoaderDetails(uuid, visitor.spec);
            for (ClassLoader parent : visitor.parents) {
                details.parents.add(this.getDetails(parent));
            }
            this.classLoaderDetails.put(classLoader, details);
            this.classLoaderIds.put(details.uuid, classLoader);
            ClassLoaderDetails classLoaderDetails = details;
            return classLoaderDetails;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class ClassLoaderSpecVisitor
    extends ClassLoaderVisitor {
        final ClassLoader classLoader;
        final List<ClassLoader> parents = new ArrayList<ClassLoader>();
        ClassLoaderSpec spec;
        URL[] classPath;

        public ClassLoaderSpecVisitor(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public void visit(ClassLoader candidate) {
            if (candidate == this.classLoader) {
                super.visit(candidate);
            } else {
                this.parents.add(candidate);
            }
        }

        public void visitClassPath(URL[] classPath) {
            this.classPath = classPath;
        }

        public void visitSpec(ClassLoaderSpec spec) {
            this.spec = spec;
        }
    }
}

