/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.server.exec.BuildCommandOnly;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecution;
import org.gradle.launcher.exec.InProcessBuildActionExecuter;
import org.gradle.launcher.exec.ReportedException;

public class ExecuteBuild
extends BuildCommandOnly {
    private static final Logger LOGGER = Logging.getLogger(ExecuteBuild.class);
    private final GradleLauncherFactory launcherFactory;

    public ExecuteBuild(GradleLauncherFactory launcherFactory) {
        this.launcherFactory = launcherFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBuild(DaemonCommandExecution execution, Build build) {
        LOGGER.info("Executing build with daemon context: {}", execution.getDaemonContext());
        InProcessBuildActionExecuter executer = new InProcessBuildActionExecuter(this.launcherFactory);
        try {
            execution.setResult(executer.execute(build.getAction(), build.getParameters()));
        }
        catch (ReportedException e) {
            execution.setException(e);
        }
        finally {
            LOGGER.debug("The daemon has finished executing the build.");
        }
        execution.proceed();
    }
}

