/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.launcher.daemon.server.exec.DaemonStateControl;
import org.gradle.launcher.daemon.server.exec.DaemonUnavailableException;
import org.slf4j.Logger;

public class DaemonStateCoordinator
implements Stoppable,
DaemonStateControl {
    private static final Logger LOGGER = Logging.getLogger(DaemonStateCoordinator.class);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private State state = State.Running;
    private long lastActivityAt = -1L;
    private String currentCommandExecution;
    private final Runnable onStartCommand;
    private final Runnable onFinishCommand;
    private Runnable onDisconnect;

    public DaemonStateCoordinator(Runnable onStartCommand, Runnable onFinishCommand) {
        this.onStartCommand = onStartCommand;
        this.onFinishCommand = onFinishCommand;
        this.updateActivityTimestamp();
    }

    private void setState(State state) {
        this.state = state;
        this.condition.signalAll();
    }

    /*
     * Exception decompiling
     */
    private boolean awaitStop(long timeoutMs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stopOnIdleTimeout(int timeout, TimeUnit timeoutUnits) {
        this.awaitStop(timeoutUnits.toMillis(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        this.lock.lock();
        try {
            LOGGER.debug("Stop as soon as idle requested. The daemon is busy: " + this.isBusy());
            if (this.isBusy()) {
                this.beginStopping();
            } else {
                this.stop();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() {
        this.lock.lock();
        try {
            LOGGER.debug("Stop requested. The daemon is running a build: " + this.isBusy());
            switch (this.state) {
                case Running: 
                case Broken: 
                case StopRequested: {
                    this.setState(State.Stopped);
                    return;
                }
                case Stopped: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Daemon is in unexpected state: " + (Object)((Object)this.state));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void beginStopping() {
        switch (this.state) {
            case Running: 
            case Broken: {
                this.setState(State.StopRequested);
                break;
            }
            case StopRequested: 
            case Stopped: {
                break;
            }
            default: {
                throw new IllegalStateException("Daemon is in unexpected state: " + (Object)((Object)this.state));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestForcefulStop() {
        this.lock.lock();
        try {
            try {
                if (this.onDisconnect != null) {
                    this.onDisconnect.run();
                }
            }
            finally {
                this.stop();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommand(Runnable command, String commandDisplayName, Runnable onCommandAbandoned) throws DaemonUnavailableException {
        this.onStartCommand(commandDisplayName, onCommandAbandoned);
        try {
            command.run();
        }
        finally {
            this.onFinishCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartCommand(String commandDisplayName, Runnable onDisconnect) {
        this.lock.lock();
        try {
            switch (this.state) {
                case Broken: {
                    throw new DaemonUnavailableException("This daemon is in a broken state and will stop.");
                }
                case StopRequested: {
                    throw new DaemonUnavailableException("This daemon is currently stopping.");
                }
                case Stopped: {
                    throw new DaemonUnavailableException("This daemon has stopped.");
                }
            }
            if (this.currentCommandExecution != null) {
                throw new DaemonUnavailableException(String.format("This daemon is currently executing: %s", this.currentCommandExecution));
            }
            LOGGER.debug("onStartCommand({}) called after {} minutes of idle", (Object)commandDisplayName, (Object)this.getIdleMinutes());
            try {
                this.onStartCommand.run();
                this.currentCommandExecution = commandDisplayName;
                this.onDisconnect = onDisconnect;
                this.updateActivityTimestamp();
                this.condition.signalAll();
            }
            catch (Throwable throwable) {
                this.setState(State.Broken);
                throw UncheckedException.throwAsUncheckedException(throwable);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onFinishCommand() {
        this.lock.lock();
        try {
            String execution = this.currentCommandExecution;
            LOGGER.debug("onFinishCommand() called while execution = {}", (Object)execution);
            this.currentCommandExecution = null;
            this.onDisconnect = null;
            this.updateActivityTimestamp();
            switch (this.state) {
                case Running: {
                    try {
                        this.onFinishCommand.run();
                        this.condition.signalAll();
                        return;
                    }
                    catch (Throwable throwable) {
                        this.setState(State.Broken);
                        throw UncheckedException.throwAsUncheckedException(throwable);
                    }
                }
                case StopRequested: {
                    this.stop();
                    return;
                }
                case Stopped: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Daemon is in unexpected state: " + (Object)((Object)this.state));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateActivityTimestamp() {
        long now = System.currentTimeMillis();
        LOGGER.debug("updating lastActivityAt to {}", (Object)now);
        this.lastActivityAt = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getIdleMinutes() {
        this.lock.lock();
        try {
            double d = (System.currentTimeMillis() - this.lastActivityAt) / 1000L / 60L;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean hasBeenIdleFor(long milliseconds) {
        return this.lastActivityAt < System.currentTimeMillis() - milliseconds;
    }

    boolean isStopped() {
        return this.state == State.Stopped;
    }

    boolean isStoppingOrStopped() {
        return this.state == State.Stopped || this.state == State.StopRequested;
    }

    boolean isIdle() {
        return this.currentCommandExecution == null;
    }

    boolean isBusy() {
        return !this.isIdle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Running,
        StopRequested,
        Stopped,
        Broken;

    }
}

