/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.configuration;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.internal.jvm.Jvm;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.process.internal.JvmOptions;

public class CurrentProcess {
    private final File javaHome;
    private final JvmOptions effectiveJvmOptions;

    public CurrentProcess() {
        this(Jvm.current().getJavaHome(), CurrentProcess.inferJvmOptions());
    }

    public CurrentProcess(File javaHome, JvmOptions effectiveJvmOptions) {
        this.javaHome = javaHome;
        this.effectiveJvmOptions = effectiveJvmOptions;
    }

    public JvmOptions getJvmOptions() {
        return this.effectiveJvmOptions;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public boolean configureForBuild(DaemonParameters requiredBuildParameters) {
        boolean noImmutableJvmArgsRequired;
        boolean javaHomeMatch = this.getJavaHome().equals(requiredBuildParameters.getEffectiveJavaHome());
        JvmOptions optionsWithNoArgsSet = new JvmOptions(new IdentityFileResolver());
        boolean bl = noImmutableJvmArgsRequired = requiredBuildParameters.isUsingDefaultJvmArgs() || requiredBuildParameters.getEffectiveJvmArgs().equals(optionsWithNoArgsSet.getAllImmutableJvmArgs());
        if (javaHomeMatch && noImmutableJvmArgsRequired) {
            Properties properties = new Properties();
            properties.putAll(requiredBuildParameters.getEffectiveSystemProperties());
            System.setProperties(properties);
            return true;
        }
        return false;
    }

    private static JvmOptions inferJvmOptions() {
        JvmOptions jvmOptions = new JvmOptions(new IdentityFileResolver());
        jvmOptions.setAllJvmArgs(ManagementFactory.getRuntimeMXBean().getInputArguments());
        return jvmOptions;
    }
}

