/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.util.List;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonConnectionException;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.DaemonStarter;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.diagnostics.DaemonStartupInfo;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.messaging.remote.internal.ConnectException;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.OutgoingConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDaemonConnector
implements DaemonConnector {
    private static final Logger LOGGER = Logging.getLogger(DefaultDaemonConnector.class);
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private final DaemonRegistry daemonRegistry;
    protected final OutgoingConnector connector;
    private final DaemonStarter daemonStarter;
    private long connectTimeout = 30000L;

    public DefaultDaemonConnector(DaemonRegistry daemonRegistry, OutgoingConnector connector, DaemonStarter daemonStarter) {
        this.daemonRegistry = daemonRegistry;
        this.connector = connector;
        this.daemonStarter = daemonStarter;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public DaemonRegistry getDaemonRegistry() {
        return this.daemonRegistry;
    }

    @Override
    public DaemonClientConnection maybeConnect(ExplainingSpec<DaemonContext> constraint) {
        return this.findConnection(this.daemonRegistry.getAll(), constraint);
    }

    @Override
    public DaemonClientConnection connect(ExplainingSpec<DaemonContext> constraint) {
        DaemonClientConnection connection = this.findConnection(this.daemonRegistry.getIdle(), constraint);
        if (connection != null) {
            return connection;
        }
        return this.startDaemon(constraint);
    }

    private DaemonClientConnection findConnection(List<DaemonInfo> daemonInfos, ExplainingSpec<DaemonContext> constraint) {
        for (DaemonInfo daemonInfo : daemonInfos) {
            if (!constraint.isSatisfiedBy(daemonInfo.getContext())) {
                LOGGER.debug("Found daemon (address: {}, idle: {}) however its context does not match the desired criteria.\n" + constraint.whyUnsatisfied(daemonInfo.getContext()) + "\n" + "  Looking for a different daemon...", daemonInfo.getAddress(), daemonInfo.isIdle());
                continue;
            }
            try {
                return this.connectToDaemon(daemonInfo, new CleanupOnStaleAddress(daemonInfo, true));
            }
            catch (ConnectException e) {
                LOGGER.debug("Cannot connect to the daemon at " + daemonInfo.getAddress() + " due to " + (Object)((Object)e) + ". Trying a different daemon...");
            }
        }
        return null;
    }

    @Override
    public DaemonClientConnection startDaemon(ExplainingSpec<DaemonContext> constraint) {
        LOGGER.info("Starting Gradle daemon");
        DaemonStartupInfo startupInfo = this.daemonStarter.startDaemon();
        LOGGER.debug("Started Gradle Daemon: {}", startupInfo);
        long expiry = System.currentTimeMillis() + this.connectTimeout;
        do {
            DaemonClientConnection daemonConnection;
            if ((daemonConnection = this.connectToDaemonWithId(startupInfo, constraint)) != null) {
                return daemonConnection;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        } while (System.currentTimeMillis() < expiry);
        throw new DaemonConnectionException("Timeout waiting to connect to the Gradle daemon.\n" + startupInfo.describe());
    }

    private DaemonClientConnection connectToDaemonWithId(DaemonStartupInfo startupInfo, ExplainingSpec<DaemonContext> constraint) throws ConnectException {
        for (DaemonInfo daemonInfo : this.daemonRegistry.getBusy()) {
            if (!daemonInfo.getContext().getUid().equals(startupInfo.getUid())) continue;
            try {
                if (!constraint.isSatisfiedBy(daemonInfo.getContext())) {
                    throw new DaemonConnectionException("The newly created daemon process has a different context than expected.\nIt won't be possible to reconnect to this daemon. Context mismatch: \n" + constraint.whyUnsatisfied(daemonInfo.getContext()));
                }
                return this.connectToDaemon(daemonInfo, new CleanupOnStaleAddress(daemonInfo, false));
            }
            catch (ConnectException e) {
                throw new DaemonConnectionException("Could not connect to the Gradle daemon.\n" + startupInfo.describe(), e);
            }
        }
        return null;
    }

    private DaemonClientConnection connectToDaemon(DaemonInfo daemonInfo, DaemonClientConnection.StaleAddressDetector staleAddressDetector) throws ConnectException {
        Connection connection;
        try {
            connection = this.connector.connect(daemonInfo.getAddress()).create(this.getClass().getClassLoader());
        }
        catch (ConnectException e) {
            staleAddressDetector.maybeStaleAddress((Exception)((Object)e));
            throw e;
        }
        return new DaemonClientConnection((Connection<Object>)connection, daemonInfo.getContext().getUid(), staleAddressDetector);
    }

    private class CleanupOnStaleAddress
    implements DaemonClientConnection.StaleAddressDetector {
        private final DaemonInfo daemonInfo;
        private final boolean exposeAsStale;

        public CleanupOnStaleAddress(DaemonInfo daemonInfo, boolean exposeAsStale) {
            this.daemonInfo = daemonInfo;
            this.exposeAsStale = exposeAsStale;
        }

        public boolean maybeStaleAddress(Exception failure) {
            LOGGER.info("Removing daemon from the registry due to communication failure. Daemon information: " + this.daemonInfo);
            DefaultDaemonConnector.this.daemonRegistry.remove(this.daemonInfo.getAddress());
            return this.exposeAsStale;
        }
    }
}

