/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.InputStream;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.cache.internal.DefaultFileLockManager;
import org.gradle.cache.internal.DefaultProcessMetaDataProvider;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.locklistener.DefaultFileLockContentionHandler;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.nativeplatform.ProcessEnvironment;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.bootstrap.DaemonGreeter;
import org.gradle.launcher.daemon.client.DaemonClientServicesSupport;
import org.gradle.launcher.daemon.client.DaemonStarter;
import org.gradle.launcher.daemon.client.DefaultDaemonStarter;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonContextBuilder;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.registry.DaemonRegistryServices;
import org.gradle.messaging.remote.internal.MessagingServices;
import org.gradle.messaging.remote.internal.inet.InetAddressFactory;

public class DaemonClientServices
extends DaemonClientServicesSupport {
    private final DaemonParameters daemonParameters;

    public DaemonClientServices(ServiceRegistry loggingServices, DaemonParameters daemonParameters, InputStream buildStandardInput) {
        super(loggingServices, buildStandardInput);
        this.daemonParameters = daemonParameters;
        this.addProvider(new DaemonRegistryServices(daemonParameters.getBaseDir()));
    }

    protected FileLockManager createFileLockManager(ProcessEnvironment processEnvironment, FileLockContentionHandler fileLockContentionHandler) {
        return new DefaultFileLockManager(new DefaultProcessMetaDataProvider(processEnvironment), fileLockContentionHandler);
    }

    protected MessagingServices createMessagingServices() {
        return new MessagingServices(this.getClass().getClassLoader());
    }

    protected FileLockContentionHandler createFileLockContentionHandler(ExecutorFactory executorFactory, MessagingServices messagingServices) {
        return new DefaultFileLockContentionHandler(executorFactory, (InetAddressFactory)messagingServices.get(InetAddressFactory.class));
    }

    protected ExecutorFactory createExecutorFactory() {
        return new DefaultExecutorFactory();
    }

    protected DocumentationRegistry createDocumentationRegistry() {
        return new DocumentationRegistry();
    }

    public DaemonStarter createDaemonStarter() {
        return new DefaultDaemonStarter(this.get(DaemonDir.class), this.daemonParameters, this.get(DaemonGreeter.class));
    }

    protected DaemonGreeter createDaemonGreeter() {
        return new DaemonGreeter(this.get(DocumentationRegistry.class));
    }

    protected void configureDaemonContextBuilder(DaemonContextBuilder builder) {
        builder.setDaemonRegistryDir(this.get(DaemonDir.class).getBaseDir());
        builder.useDaemonParameters(this.daemonParameters);
    }

    public DaemonParameters getDaemonParameters() {
        return this.daemonParameters;
    }
}

