/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.InputStream;
import org.gradle.api.Nullable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.io.TextStream;
import org.gradle.launcher.daemon.client.InputForwarder;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.IoCommand;
import org.gradle.messaging.dispatch.Dispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonClientInputForwarder
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DaemonClientInputForwarder.class);
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final InputForwarder forwarder;

    public DaemonClientInputForwarder(InputStream inputStream, Dispatch<? super IoCommand> dispatch, ExecutorFactory executorFactory, IdGenerator<?> idGenerator) {
        this(inputStream, dispatch, executorFactory, idGenerator, 1024);
    }

    public DaemonClientInputForwarder(InputStream inputStream, final Dispatch<? super IoCommand> dispatch, ExecutorFactory executorFactory, final IdGenerator<?> idGenerator, int bufferSize) {
        TextStream handler = new TextStream(){

            public void text(String input) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Forwarding input to daemon: '{}'", input.replace("\n", "\\n"));
                }
                dispatch.dispatch((Object)new ForwardInput(idGenerator.generateId(), input.getBytes()));
            }

            public void endOfStream(@Nullable Throwable failure) {
                CloseInput message = new CloseInput(idGenerator.generateId());
                LOGGER.debug("Dispatching close input message: {}", message);
                dispatch.dispatch((Object)message);
            }
        };
        this.forwarder = new InputForwarder(inputStream, handler, executorFactory, bufferSize);
    }

    public DaemonClientInputForwarder start() {
        this.forwarder.start();
        return this;
    }

    @Override
    public void stop() {
        this.forwarder.stop();
    }
}

