/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.InputStream;
import java.util.HashSet;
import org.gradle.api.GradleException;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildAction;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonClientInputForwarder;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.DaemonDisappearedException;
import org.gradle.launcher.daemon.client.DaemonInitialConnectException;
import org.gradle.launcher.daemon.client.NoUsableDaemonFoundException;
import org.gradle.launcher.daemon.client.StaleDaemonAddressException;
import org.gradle.launcher.daemon.client.StopDispatcher;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.protocol.BuildStarted;
import org.gradle.launcher.daemon.protocol.DaemonUnavailable;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Finished;
import org.gradle.launcher.daemon.protocol.IoCommand;
import org.gradle.launcher.daemon.protocol.Result;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.remote.internal.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonClient
implements BuildActionExecuter<BuildActionParameters> {
    private static final Logger LOGGER = Logging.getLogger(DaemonClient.class);
    private static final int STOP_TIMEOUT_SECONDS = 30;
    private final DaemonConnector connector;
    private final OutputEventListener outputEventListener;
    private final ExplainingSpec<DaemonContext> compatibilitySpec;
    private final InputStream buildStandardInput;
    private final ExecutorFactory executorFactory;
    private final IdGenerator<?> idGenerator;

    public DaemonClient(DaemonConnector connector, OutputEventListener outputEventListener, ExplainingSpec<DaemonContext> compatibilitySpec, InputStream buildStandardInput, ExecutorFactory executorFactory, IdGenerator<?> idGenerator) {
        this.connector = connector;
        this.outputEventListener = outputEventListener;
        this.compatibilitySpec = compatibilitySpec;
        this.buildStandardInput = buildStandardInput;
        this.executorFactory = executorFactory;
        this.idGenerator = idGenerator;
    }

    protected IdGenerator<?> getIdGenerator() {
        return this.idGenerator;
    }

    protected DaemonConnector getConnector() {
        return this.connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        long start = System.currentTimeMillis();
        long expiry = start + 30000L;
        HashSet<String> stopped = new HashSet<String>();
        DaemonClientConnection connection = this.connector.maybeConnect(this.compatibilitySpec);
        if (connection == null) {
            LOGGER.lifecycle("No Gradle daemons are running.");
            return;
        }
        LOGGER.lifecycle("Stopping daemon(s).");
        while (connection != null && System.currentTimeMillis() < expiry) {
            try {
                if (stopped.add(connection.getUid())) {
                    new StopDispatcher(this.idGenerator).dispatch(connection);
                    LOGGER.lifecycle("Gradle daemon stopped.");
                }
            }
            finally {
                connection.stop();
            }
            connection = this.connector.maybeConnect(this.compatibilitySpec);
        }
        if (connection != null) {
            throw new GradleException(String.format("Timeout waiting for all daemons to stop. Waited %s seconds.", (System.currentTimeMillis() - start) / 1000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(BuildAction<T> action, BuildActionParameters parameters) {
        Build build = new Build(this.idGenerator.generateId(), action, parameters);
        int saneNumberOfAttempts = 100;
        for (int i = 1; i < saneNumberOfAttempts; ++i) {
            DaemonClientConnection connection = this.connector.connect(this.compatibilitySpec);
            try {
                Object object = this.executeBuild(build, connection);
                return (T)object;
            }
            catch (DaemonInitialConnectException e) {
                LOGGER.info(e.getMessage() + " Trying a different daemon...");
                continue;
            }
            finally {
                connection.stop();
            }
        }
        throw new NoUsableDaemonFoundException("Unable to find a usable idle daemon. I have connected to " + saneNumberOfAttempts + " different daemons but I could not use any of them to run build: " + build + ".");
    }

    protected Object executeBuild(Build build, DaemonClientConnection connection) throws DaemonInitialConnectException {
        Object result;
        try {
            LOGGER.info("Connected to the daemon. Dispatching {} request.", build);
            connection.dispatch(build);
            result = connection.receive();
        }
        catch (StaleDaemonAddressException e) {
            LOGGER.debug("Connected to a stale daemon address.", e);
            throw new DaemonInitialConnectException("Connected to a stale daemon address.", e);
        }
        if (result == null) {
            throw new DaemonInitialConnectException("The first result from the daemon was empty. Most likely the process died immediately after connection.");
        }
        if (result instanceof BuildStarted) {
            DaemonDiagnostics diagnostics = ((BuildStarted)result).getDiagnostics();
            result = this.monitorBuild(build, diagnostics, connection);
        }
        connection.dispatch(new Finished());
        if (result instanceof Failure) {
            throw UncheckedException.throwAsUncheckedException((Throwable)((Failure)result).getValue());
        }
        if (result instanceof DaemonUnavailable) {
            throw new DaemonInitialConnectException("The daemon we connected to was unavailable: " + ((DaemonUnavailable)result).getReason());
        }
        if (result instanceof Result) {
            return ((Result)result).getValue();
        }
        throw this.invalidResponse(result, build);
    }

    private Object monitorBuild(Build build, DaemonDiagnostics diagnostics, Connection<Object> connection) {
        DaemonClientInputForwarder inputForwarder = new DaemonClientInputForwarder(this.buildStandardInput, (Dispatch<? super IoCommand>)connection, this.executorFactory, this.idGenerator);
        try {
            inputForwarder.start();
            int objectsReceived = 0;
            while (true) {
                Object object = connection.receive();
                LOGGER.trace("Received object #{}, type: {}", objectsReceived++, object == null ? null : object.getClass().getName());
                if (object == null) {
                    Result result = this.handleDaemonDisappearance(build, diagnostics);
                    return result;
                }
                if (!(object instanceof OutputEvent)) {
                    Object object2 = object;
                    return object2;
                }
                this.outputEventListener.onOutput((OutputEvent)object);
            }
        }
        finally {
            inputForwarder.stop();
        }
    }

    private Result handleDaemonDisappearance(Build build, DaemonDiagnostics diagnostics) {
        LOGGER.error("The message received from the daemon indicates that the daemon has disappeared.\nBuild request sent: " + build + "\nAttempting to read last messages from the daemon log...");
        LOGGER.error(diagnostics.describe());
        throw new DaemonDisappearedException();
    }

    private IllegalStateException invalidResponse(Object response, Build command) {
        return new IllegalStateException(String.format("Received invalid response from the daemon: '%s' is a result of a type we don't have a strategy to handle.Earlier, '%s' request was sent to the daemon.", response, command));
    }
}

