/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.file;

import java.io.IOException;
import java.net.URI;
import org.gradle.api.Nullable;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.internal.resource.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transport.AbstractRepositoryTransport;
import org.gradle.internal.resource.transport.DefaultExternalResourceRepository;
import org.gradle.internal.resource.transport.ExternalResourceRepository;
import org.gradle.internal.resource.transport.file.FileResourceConnector;

public class FileTransport
extends AbstractRepositoryTransport {
    private final ExternalResourceRepository repository;
    private final NoOpCacheAwareExternalResourceAccessor resourceAccessor;

    public FileTransport(String name, TemporaryFileProvider temporaryFileProvider) {
        super(name);
        FileResourceConnector connector = new FileResourceConnector();
        this.resourceAccessor = new NoOpCacheAwareExternalResourceAccessor(connector);
        this.repository = new DefaultExternalResourceRepository(name, connector, connector, connector, temporaryFileProvider);
    }

    public boolean isLocal() {
        return true;
    }

    public ExternalResourceRepository getRepository() {
        return this.repository;
    }

    public CacheAwareExternalResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    private static class NoOpCacheAwareExternalResourceAccessor
    implements CacheAwareExternalResourceAccessor {
        private final FileResourceConnector connector;

        public NoOpCacheAwareExternalResourceAccessor(FileResourceConnector connector) {
            this.connector = connector;
        }

        public LocallyAvailableExternalResource getResource(URI source, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, @Nullable LocallyAvailableResourceCandidates localCandidates) throws IOException {
            return this.connector.getResource(source);
        }
    }
}

