/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.Factory;
import org.gradle.internal.resource.transfer.AbstractProgressLoggingHandler;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transfer.ResourceOperation;
import org.gradle.logging.ProgressLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressLoggingExternalResourceUploader
extends AbstractProgressLoggingHandler
implements ExternalResourceUploader {
    private final ExternalResourceUploader delegate;

    public ProgressLoggingExternalResourceUploader(ExternalResourceUploader delegate, ProgressLoggerFactory progressLoggerFactory) {
        super(progressLoggerFactory);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(final Factory<InputStream> source, Long contentLength, URI destination) throws IOException {
        final ResourceOperation uploadOperation = this.createResourceOperation(destination.toString(), ResourceOperation.Type.upload, this.getClass(), contentLength);
        try {
            this.delegate.upload((Factory)new Factory<InputStream>(){

                public InputStream create() {
                    return new ProgressLoggingInputStream((InputStream)source.create(), uploadOperation);
                }
            }, contentLength, destination);
        }
        finally {
            uploadOperation.completed();
        }
    }

    private class ProgressLoggingInputStream
    extends InputStream {
        private InputStream inputStream;
        private final ResourceOperation resourceOperation;

        public ProgressLoggingInputStream(InputStream inputStream, ResourceOperation resourceOperation) {
            this.inputStream = inputStream;
            this.resourceOperation = resourceOperation;
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public int read() throws IOException {
            int result = this.inputStream.read();
            if (result >= 0) {
                this.doLogProgress(1L);
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.inputStream.read(b, off, len);
            if (read > 0) {
                this.doLogProgress(read);
            }
            return read;
        }

        private void doLogProgress(long numberOfBytes) {
            this.resourceOperation.logProcessedBytes(numberOfBytes);
        }
    }
}

