/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.AbstractProgressLoggingHandler;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ResourceOperation;
import org.gradle.logging.ProgressLoggerFactory;

public class ProgressLoggingExternalResourceAccessor
extends AbstractProgressLoggingHandler
implements ExternalResourceAccessor {
    private final ExternalResourceAccessor delegate;

    public ProgressLoggingExternalResourceAccessor(ExternalResourceAccessor delegate, ProgressLoggerFactory progressLoggerFactory) {
        super(progressLoggerFactory);
        this.delegate = delegate;
    }

    public ExternalResource getResource(URI location) throws IOException {
        ExternalResource resource = this.delegate.getResource(location);
        if (resource != null) {
            return new ProgressLoggingExternalResource(resource);
        }
        return null;
    }

    @Nullable
    public HashValue getResourceSha1(URI location) {
        return this.delegate.getResourceSha1(location);
    }

    @Nullable
    public ExternalResourceMetaData getMetaData(URI location) throws IOException {
        return this.delegate.getMetaData(location);
    }

    private class ProgressLoggingOutputStream
    extends OutputStream {
        private OutputStream outputStream;
        private final ResourceOperation resourceOperation;

        public ProgressLoggingOutputStream(OutputStream outputStream, ResourceOperation resourceOperation) {
            this.outputStream = outputStream;
            this.resourceOperation = resourceOperation;
        }

        public void flush() throws IOException {
            this.outputStream.flush();
        }

        public void close() throws IOException {
            this.outputStream.close();
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
            this.resourceOperation.logProcessedBytes(1L);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
            this.resourceOperation.logProcessedBytes(len);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProgressLoggingExternalResource
    implements ExternalResource {
        private ExternalResource resource;

        private ProgressLoggingExternalResource(ExternalResource resource) {
            this.resource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(File destination) throws IOException {
            FileOutputStream output = new FileOutputStream(destination);
            try {
                this.writeTo(output);
            }
            finally {
                output.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream outputStream) throws IOException {
            ResourceOperation downloadOperation = ProgressLoggingExternalResourceAccessor.this.createResourceOperation(this.resource.getName(), ResourceOperation.Type.download, this.getClass(), this.resource.getContentLength());
            ProgressLoggingOutputStream progressLoggingOutputStream = new ProgressLoggingOutputStream(outputStream, downloadOperation);
            try {
                this.resource.writeTo((OutputStream)progressLoggingOutputStream);
            }
            finally {
                downloadOperation.completed();
            }
        }

        public void withContent(Action<? super InputStream> readAction) throws IOException {
            this.resource.withContent(readAction);
        }

        public <T> T withContent(Transformer<? extends T, ? super InputStream> readAction) throws IOException {
            return (T)this.resource.withContent(readAction);
        }

        public void close() throws IOException {
            this.resource.close();
        }

        @Nullable
        public ExternalResourceMetaData getMetaData() {
            return this.resource.getMetaData();
        }

        public URI getURI() {
            return this.resource.getURI();
        }

        public String getName() {
            return this.resource.getName();
        }

        public long getContentLength() {
            return this.resource.getContentLength();
        }

        public boolean isLocal() {
            return this.resource.isLocal();
        }

        public String toString() {
            return this.resource.toString();
        }
    }
}

