/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local.ivy;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.SingleIncludePatternFileTree;
import org.gradle.internal.Factory;
import org.gradle.internal.resource.local.AbstractLocallyAvailableResourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBasedLocallyAvailableResourceFinder
extends AbstractLocallyAvailableResourceFinder<ModuleVersionArtifactMetaData> {
    public PatternBasedLocallyAvailableResourceFinder(File baseDir, ResourcePattern pattern) {
        super(PatternBasedLocallyAvailableResourceFinder.createProducer(baseDir, pattern));
    }

    private static Transformer<Factory<List<File>>, ModuleVersionArtifactMetaData> createProducer(final File baseDir, final ResourcePattern pattern) {
        return new Transformer<Factory<List<File>>, ModuleVersionArtifactMetaData>(){

            public Factory<List<File>> transform(final ModuleVersionArtifactMetaData artifact) {
                return new Factory<List<File>>(){

                    public List<File> create() {
                        final LinkedList<File> files = new LinkedList<File>();
                        if (artifact != null) {
                            this.getMatchingFiles(artifact).visit((FileVisitor)new EmptyFileVisitor(){

                                public void visitFile(FileVisitDetails fileDetails) {
                                    files.add(fileDetails.getFile());
                                }
                            });
                        }
                        return files;
                    }
                };
            }

            private MinimalFileTree getMatchingFiles(ModuleVersionArtifactMetaData artifact) {
                String patternString = pattern.getLocation(artifact).getPath();
                return new SingleIncludePatternFileTree(baseDir, patternString);
            }
        };
    }
}

