/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.artifacts.dependencies.DefaultSelfResolvingDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyClassPathNotationParser
implements NotationConverter<DependencyFactory.ClassPathNotation, SelfResolvingDependency> {
    private final ClassPathRegistry classPathRegistry;
    private final Instantiator instantiator;
    private final FileResolver fileResolver;

    public DependencyClassPathNotationParser(Instantiator instantiator, ClassPathRegistry classPathRegistry, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.classPathRegistry = classPathRegistry;
        this.fileResolver = fileResolver;
    }

    public void describe(Collection<String> candidateFormats) {
        candidateFormats.add("ClassPathNotation, e.g. gradleApi().");
    }

    public void convert(DependencyFactory.ClassPathNotation notation, NotationConvertResult<? super SelfResolvingDependency> result) throws TypeConversionException {
        List classpath = this.classPathRegistry.getClassPath(notation.name()).getAsFiles();
        FileCollection files = this.fileResolver.resolveFiles(new Object[]{classpath});
        result.converted(this.instantiator.newInstance(DefaultSelfResolvingDependency.class, new Object[]{files}));
    }
}

