/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.result;

import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.internal.artifacts.component.DefaultModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.result.AbstractDependencyResult;

public class DefaultUnresolvedDependencyResult
extends AbstractDependencyResult
implements UnresolvedDependencyResult {
    private final ComponentSelectionReason reason;
    private final ModuleVersionResolveException failure;

    public DefaultUnresolvedDependencyResult(ComponentSelector requested, ComponentSelectionReason reason, ResolvedComponentResult from, ModuleVersionResolveException failure) {
        super(requested, from);
        this.reason = reason;
        this.failure = failure;
    }

    public ModuleVersionResolveException getFailure() {
        return this.failure;
    }

    public ModuleComponentSelector getAttempted() {
        ModuleVersionSelector moduleVersionSelector = this.failure.getSelector();
        return DefaultModuleComponentSelector.newSelector(moduleVersionSelector.getGroup(), moduleVersionSelector.getName(), moduleVersionSelector.getVersion());
    }

    public ComponentSelectionReason getAttemptedReason() {
        return this.reason;
    }

    public String toString() {
        return String.format("%s -> %s - %s", this.getRequested(), this.getAttempted(), this.failure.getMessage());
    }
}

