/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.metadata.DefaultModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.internal.resource.LocallyAvailableExternalResource;

class MavenUniqueSnapshotExternalResourceArtifactResolver
implements ExternalResourceArtifactResolver {
    private final ExternalResourceArtifactResolver delegate;
    private final String timestamp;

    public MavenUniqueSnapshotExternalResourceArtifactResolver(ExternalResourceArtifactResolver delegate, String timestamp) {
        this.delegate = delegate;
        this.timestamp = timestamp;
    }

    public boolean artifactExists(ModuleVersionArtifactMetaData artifact, ResourceAwareResolveResult result) {
        return this.delegate.artifactExists(this.timestamp(artifact), result);
    }

    public LocallyAvailableExternalResource resolveArtifact(ModuleVersionArtifactMetaData artifact, ResourceAwareResolveResult result) {
        return this.delegate.resolveArtifact(this.timestamp(artifact), result);
    }

    public LocallyAvailableExternalResource resolveMetaDataArtifact(ModuleVersionArtifactMetaData artifact, ResourceAwareResolveResult result) {
        return this.delegate.resolveMetaDataArtifact(this.timestamp(artifact), result);
    }

    protected ModuleVersionArtifactMetaData timestamp(ModuleVersionArtifactMetaData artifact) {
        MavenUniqueSnapshotComponentIdentifier snapshotComponentIdentifier = new MavenUniqueSnapshotComponentIdentifier(artifact.getId().getComponentIdentifier(), this.timestamp);
        return new DefaultModuleVersionArtifactMetaData((ModuleComponentIdentifier)snapshotComponentIdentifier, artifact.getName());
    }
}

