/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactSetResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BuildableModuleVersionMetaDataResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.GradlePomModuleDescriptorParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ConfigurationMetaData;
import org.gradle.api.internal.artifacts.metadata.DefaultIvyArtifactName;
import org.gradle.api.internal.artifacts.metadata.DefaultMavenModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.gradle.api.internal.artifacts.metadata.IvyArtifactName;
import org.gradle.api.internal.artifacts.metadata.MavenModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;
import org.gradle.api.internal.artifacts.repositories.resolver.ChainedVersionLister;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.M2ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenMetadata;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenMetadataLoader;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotModuleSource;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenVersionLister;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourceVersionLister;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Transformers;
import org.gradle.internal.resource.LocallyAvailableExternalResource;
import org.gradle.internal.resource.ResourceNotFoundException;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenResolver
extends ExternalResourceResolver {
    private final URI root;
    private final List<URI> artifactRoots = new ArrayList<URI>();
    private final MavenMetadataLoader mavenMetaDataLoader;
    private final MetaDataParser metaDataParser = new GradlePomModuleDescriptorParser();

    public MavenResolver(String name, URI rootUri, RepositoryTransport transport, LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData> locallyAvailableResourceFinder, FileStore<ModuleVersionArtifactMetaData> artifactFileStore) {
        super(name, transport.isLocal(), transport.getRepository(), transport.getResourceAccessor(), new ChainedVersionLister(new MavenVersionLister(transport.getRepository()), new ResourceVersionLister(transport.getRepository())), locallyAvailableResourceFinder, artifactFileStore);
        this.mavenMetaDataLoader = new MavenMetadataLoader(transport.getRepository());
        this.root = rootUri;
        this.updatePatterns();
    }

    public URI getRoot() {
        return this.root;
    }

    @Override
    protected void doResolveComponentMetaData(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleVersionMetaDataResolveResult result) {
        MavenUniqueSnapshotModuleSource uniqueSnapshotVersion;
        if (this.isSnapshotVersion(moduleComponentIdentifier) && (uniqueSnapshotVersion = this.findUniqueSnapshotVersion(moduleComponentIdentifier, result)) != null) {
            this.resolveUniqueSnapshotDependency(dependency, moduleComponentIdentifier, result, uniqueSnapshotVersion);
            return;
        }
        this.resolveStaticDependency(dependency, moduleComponentIdentifier, result, super.createArtifactResolver());
    }

    @Override
    protected boolean isMetaDataArtifact(ArtifactType artifactType) {
        return artifactType == ArtifactType.MAVEN_POM;
    }

    @Override
    protected MutableModuleVersionMetaData processMetaData(MutableModuleVersionMetaData metaData) {
        if (metaData.getId().getVersion().endsWith("-SNAPSHOT")) {
            metaData.setChanging(true);
        }
        return metaData;
    }

    private void resolveUniqueSnapshotDependency(DependencyMetaData dependency, ModuleComponentIdentifier module, BuildableModuleVersionMetaDataResolveResult result, MavenUniqueSnapshotModuleSource snapshotSource) {
        this.resolveStaticDependency(dependency, module, result, this.createArtifactResolver(snapshotSource));
        if (result.getState() == BuildableModuleVersionMetaDataResolveResult.State.Resolved) {
            result.setModuleSource(snapshotSource);
        }
    }

    private boolean isSnapshotVersion(ModuleComponentIdentifier module) {
        return module.getVersion().endsWith("-SNAPSHOT");
    }

    @Override
    protected ExternalResourceArtifactResolver createArtifactResolver(ModuleSource moduleSource) {
        if (moduleSource instanceof MavenUniqueSnapshotModuleSource) {
            String timestamp = ((MavenUniqueSnapshotModuleSource)moduleSource).getTimestamp();
            return new MavenUniqueSnapshotExternalResourceArtifactResolver(super.createArtifactResolver(moduleSource), timestamp);
        }
        return super.createArtifactResolver(moduleSource);
    }

    public void addArtifactLocation(URI baseUri) {
        this.artifactRoots.add(baseUri);
        this.updatePatterns();
    }

    private M2ResourcePattern getWholePattern() {
        return new M2ResourcePattern(this.root, "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]");
    }

    private void updatePatterns() {
        this.setIvyPatterns(Collections.singletonList(this.getWholePattern()));
        ArrayList<ResourcePattern> artifactPatterns = new ArrayList<ResourcePattern>();
        artifactPatterns.add(this.getWholePattern());
        for (URI artifactRoot : this.artifactRoots) {
            artifactPatterns.add(new M2ResourcePattern(artifactRoot, "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]"));
        }
        this.setArtifactPatterns(artifactPatterns);
    }

    @Override
    protected IvyArtifactName getMetaDataArtifactName(String moduleName) {
        return new DefaultIvyArtifactName(moduleName, "pom", "pom");
    }

    private MavenUniqueSnapshotModuleSource findUniqueSnapshotVersion(ModuleComponentIdentifier module, ResourceAwareResolveResult result) {
        URI metadataLocation = this.getWholePattern().toModuleVersionPath(module).resolve("maven-metadata.xml").getUri();
        result.attempted(metadataLocation.toString());
        MavenMetadata mavenMetadata = this.parseMavenMetadata(metadataLocation);
        if (mavenMetadata.timestamp != null) {
            String timestamp = String.format("%s-%s", mavenMetadata.timestamp, mavenMetadata.buildNumber);
            return new MavenUniqueSnapshotModuleSource(timestamp);
        }
        return null;
    }

    private MavenMetadata parseMavenMetadata(URI metadataLocation) {
        try {
            return this.mavenMetaDataLoader.load(metadataLocation);
        }
        catch (ResourceNotFoundException e) {
            return new MavenMetadata();
        }
    }

    @Override
    public boolean isM2compatible() {
        return true;
    }

    @Override
    public ModuleComponentRepositoryAccess getLocalAccess() {
        return new MavenLocalRepositoryAccess();
    }

    @Override
    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return new MavenRemoteRepositoryAccess();
    }

    @Override
    protected MutableModuleVersionMetaData createMetaDataForDependency(DependencyMetaData dependency) {
        return new DefaultMavenModuleVersionMetaData(dependency);
    }

    @Override
    protected MutableModuleVersionMetaData parseMetaDataFromResource(LocallyAvailableExternalResource cachedResource, DescriptorParseContext context) {
        return this.metaDataParser.parseMetaData(context, cachedResource);
    }

    protected static MavenModuleVersionMetaData mavenMetaData(ModuleVersionMetaData metaData) {
        return (MavenModuleVersionMetaData)Transformers.cast(MavenModuleVersionMetaData.class).transform((Object)metaData);
    }

    private class MavenRemoteRepositoryAccess
    extends ExternalResourceResolver.RemoteRepositoryAccess {
        private MavenRemoteRepositoryAccess() {
            super(MavenResolver.this);
        }

        protected void resolveConfigurationArtifacts(ModuleVersionMetaData module, ConfigurationMetaData configuration, BuildableArtifactSetResolveResult result) {
            MavenModuleVersionMetaData mavenMetaData = MavenResolver.mavenMetaData(module);
            if (mavenMetaData.isPomPackaging()) {
                LinkedHashSet<ModuleVersionArtifactMetaData> artifacts = new LinkedHashSet<ModuleVersionArtifactMetaData>();
                artifacts.addAll(MavenResolver.this.findOptionalArtifacts(module, "jar", null));
                result.resolved(artifacts);
            } else {
                ModuleVersionArtifactMetaData artifactMetaData = module.artifact(mavenMetaData.getPackaging(), mavenMetaData.getPackaging(), null);
                if (MavenResolver.this.createArtifactResolver(module.getSource()).artifactExists(artifactMetaData, new DefaultResourceAwareResolveResult())) {
                    result.resolved((Collection<? extends ComponentArtifactMetaData>)ImmutableSet.of((Object)artifactMetaData));
                } else {
                    ModuleVersionArtifactMetaData artifact = module.artifact("jar", "jar", null);
                    result.resolved((Collection<? extends ComponentArtifactMetaData>)ImmutableSet.of((Object)artifact));
                }
            }
        }

        protected void resolveJavadocArtifacts(ModuleVersionMetaData module, BuildableArtifactSetResolveResult result) {
            result.resolved(MavenResolver.this.findOptionalArtifacts(module, "javadoc", "javadoc"));
        }

        protected void resolveSourceArtifacts(ModuleVersionMetaData module, BuildableArtifactSetResolveResult result) {
            result.resolved(MavenResolver.this.findOptionalArtifacts(module, "source", "sources"));
        }
    }

    private class MavenLocalRepositoryAccess
    extends ExternalResourceResolver.LocalRepositoryAccess {
        private MavenLocalRepositoryAccess() {
            super(MavenResolver.this);
        }

        protected void resolveConfigurationArtifacts(ModuleVersionMetaData module, ConfigurationMetaData configuration, BuildableArtifactSetResolveResult result) {
            if (MavenResolver.mavenMetaData(module).isKnownJarPackaging()) {
                ModuleVersionArtifactMetaData artifact = module.artifact("jar", "jar", null);
                result.resolved((Collection<? extends ComponentArtifactMetaData>)ImmutableSet.of((Object)artifact));
            }
        }

        protected void resolveJavadocArtifacts(ModuleVersionMetaData module, BuildableArtifactSetResolveResult result) {
        }

        protected void resolveSourceArtifacts(ModuleVersionMetaData module, BuildableArtifactSetResolveResult result) {
        }
    }
}

