/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.net.URI;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.metadata.MavenModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenResolver;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenLocalResolver
extends MavenResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenResolver.class);

    public MavenLocalResolver(String name, URI rootUri, RepositoryTransport transport, LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData> locallyAvailableResourceFinder, FileStore<ModuleVersionArtifactMetaData> artifactFileStore) {
        super(name, rootUri, transport, locallyAvailableResourceFinder, artifactFileStore);
    }

    @Override
    protected MutableModuleVersionMetaData parseMetaDataFromArtifact(ModuleComponentIdentifier moduleComponentIdentifier, ExternalResourceArtifactResolver artifactResolver, ResourceAwareResolveResult result) {
        MutableModuleVersionMetaData metaData = super.parseMetaDataFromArtifact(moduleComponentIdentifier, artifactResolver, result);
        if (metaData == null) {
            return null;
        }
        if (this.isOrphanedPom(MavenLocalResolver.mavenMetaData(metaData), artifactResolver)) {
            return null;
        }
        return metaData;
    }

    private boolean isOrphanedPom(MavenModuleVersionMetaData metaData, ExternalResourceArtifactResolver artifactResolver) {
        ModuleVersionArtifactMetaData customArtifactMetaData;
        if (metaData.isPomPackaging()) {
            return false;
        }
        if (!metaData.isKnownJarPackaging() && artifactResolver.artifactExists(customArtifactMetaData = metaData.artifact(metaData.getPackaging(), metaData.getPackaging(), null), new DefaultResourceAwareResolveResult())) {
            return false;
        }
        ModuleVersionArtifactMetaData artifact = metaData.artifact("jar", "jar", null);
        if (artifactResolver.artifactExists(artifact, new DefaultResourceAwareResolveResult())) {
            return false;
        }
        LOGGER.debug("POM file found for module '{}' in repository '{}' but no artifact found. Ignoring.", (Object)metaData.getId(), (Object)this.getName());
        return true;
    }
}

