/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactSetResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ComponentUsage;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ArtifactResolveException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BuildableModuleVersionMetaDataResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BuildableModuleVersionSelectionResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DependencyResolverIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChain;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.ConfigurationMetaData;
import org.gradle.api.internal.artifacts.metadata.DefaultIvyArtifactName;
import org.gradle.api.internal.artifacts.metadata.DefaultModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.gradle.api.internal.artifacts.metadata.IvyArtifactName;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactPublishMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionPublishMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;
import org.gradle.api.internal.artifacts.repositories.resolver.DefaultExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolverDescriptorParseContext;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionLister;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionPatternVisitor;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.resource.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transport.ExternalResourceRepository;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExternalResourceResolver
implements ModuleVersionPublisher,
ConfiguredModuleComponentRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalResourceResolver.class);
    private List<ResourcePattern> ivyPatterns = new ArrayList<ResourcePattern>();
    private List<ResourcePattern> artifactPatterns = new ArrayList<ResourcePattern>();
    private String name;
    private RepositoryChain repositoryChain;
    private final ExternalResourceRepository repository;
    private final boolean local;
    private final CacheAwareExternalResourceAccessor cachingResourceAccessor;
    private final LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData> locallyAvailableResourceFinder;
    private final FileStore<ModuleVersionArtifactMetaData> artifactFileStore;
    private final VersionLister versionLister;

    public ExternalResourceResolver(String name, boolean local, ExternalResourceRepository repository, CacheAwareExternalResourceAccessor cachingResourceAccessor, VersionLister versionLister, LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData> locallyAvailableResourceFinder, FileStore<ModuleVersionArtifactMetaData> artifactFileStore) {
        this.name = name;
        this.local = local;
        this.cachingResourceAccessor = cachingResourceAccessor;
        this.versionLister = versionLister;
        this.repository = repository;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
    }

    @Override
    public String getId() {
        return DependencyResolverIdentifier.forExternalResourceResolver(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isDynamicResolveMode() {
        return false;
    }

    public String toString() {
        return String.format("Repository '%s'", this.getName());
    }

    public void setRepositoryChain(RepositoryChain resolver) {
        this.repositoryChain = resolver;
    }

    protected ExternalResourceRepository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    private void doListModuleVersions(DependencyMetaData dependency, BuildableModuleVersionSelectionResolveResult result) {
        DefaultModuleIdentifier module = new DefaultModuleIdentifier(dependency.getRequested().getGroup(), dependency.getRequested().getName());
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        VersionPatternVisitor visitor = this.versionLister.newVisitor(module, versions, result);
        IvyArtifactName metaDataArtifact = this.getMetaDataArtifactName(dependency.getRequested().getName());
        this.listVersionsForAllPatterns(this.ivyPatterns, metaDataArtifact, visitor);
        for (IvyArtifactName otherArtifact : this.getDependencyArtifactNames(dependency)) {
            this.listVersionsForAllPatterns(this.artifactPatterns, otherArtifact, visitor);
        }
        result.listed(versions);
    }

    private void listVersionsForAllPatterns(List<ResourcePattern> patternList, IvyArtifactName ivyArtifactName, VersionPatternVisitor visitor) {
        for (ResourcePattern resourcePattern : patternList) {
            visitor.visit(resourcePattern, ivyArtifactName);
        }
    }

    protected void doResolveComponentMetaData(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleVersionMetaDataResolveResult result) {
        this.resolveStaticDependency(dependency, moduleComponentIdentifier, result, this.createArtifactResolver());
    }

    protected final void resolveStaticDependency(DependencyMetaData dependency, ModuleComponentIdentifier moduleVersionIdentifier, BuildableModuleVersionMetaDataResolveResult result, ExternalResourceArtifactResolver artifactResolver) {
        MutableModuleVersionMetaData metaDataArtifactMetaData = this.parseMetaDataFromArtifact(moduleVersionIdentifier, artifactResolver, result);
        if (metaDataArtifactMetaData != null) {
            LOGGER.debug("Metadata file found for module '{}' in repository '{}'.", (Object)moduleVersionIdentifier, (Object)this.getName());
            result.resolved(metaDataArtifactMetaData, null);
            return;
        }
        MutableModuleVersionMetaData metaDataFromDefaultArtifact = this.createMetaDataFromDefaultArtifact(moduleVersionIdentifier, dependency, artifactResolver, result);
        if (metaDataFromDefaultArtifact != null) {
            LOGGER.debug("Found artifact but no meta-data for module '{}' in repository '{}', using default meta-data.", (Object)moduleVersionIdentifier, (Object)this.getName());
            result.resolved(metaDataFromDefaultArtifact, null);
            return;
        }
        LOGGER.debug("No meta-data file or artifact found for module '{}' in repository '{}'.", (Object)moduleVersionIdentifier, (Object)this.getName());
        result.missing();
    }

    protected MutableModuleVersionMetaData parseMetaDataFromArtifact(ModuleComponentIdentifier moduleVersionIdentifier, ExternalResourceArtifactResolver artifactResolver, ResourceAwareResolveResult result) {
        ModuleVersionArtifactMetaData artifact = this.getMetaDataArtifactFor(moduleVersionIdentifier);
        LocallyAvailableExternalResource metaDataResource = artifactResolver.resolveMetaDataArtifact(artifact, result);
        if (metaDataResource == null) {
            return null;
        }
        ExternalResourceResolverDescriptorParseContext context = new ExternalResourceResolverDescriptorParseContext(this.repositoryChain);
        MutableModuleVersionMetaData metaData = this.parseMetaDataFromResource(metaDataResource, context);
        metaData = this.processMetaData(metaData);
        this.checkMetadataConsistency(moduleVersionIdentifier, metaData);
        return metaData;
    }

    private MutableModuleVersionMetaData createMetaDataFromDefaultArtifact(ModuleComponentIdentifier moduleVersionIdentifier, DependencyMetaData dependency, ExternalResourceArtifactResolver artifactResolver, ResourceAwareResolveResult result) {
        for (IvyArtifactName artifact : this.getDependencyArtifactNames(dependency)) {
            if (!artifactResolver.artifactExists(new DefaultModuleVersionArtifactMetaData(moduleVersionIdentifier, artifact), result)) continue;
            MutableModuleVersionMetaData metaData = this.createMetaDataForDependency(dependency);
            return this.processMetaData(metaData);
        }
        return null;
    }

    protected abstract MutableModuleVersionMetaData createMetaDataForDependency(DependencyMetaData var1);

    protected abstract MutableModuleVersionMetaData parseMetaDataFromResource(LocallyAvailableExternalResource var1, DescriptorParseContext var2);

    private Set<IvyArtifactName> getDependencyArtifactNames(DependencyMetaData dependency) {
        String moduleName = dependency.getRequested().getName();
        LinkedHashSet artifactSet = Sets.newLinkedHashSet();
        DependencyDescriptor dependencyDescriptor = dependency.getDescriptor();
        for (DependencyArtifactDescriptor artifact : dependencyDescriptor.getAllDependencyArtifacts()) {
            artifactSet.add(new DefaultIvyArtifactName(moduleName, artifact.getType(), artifact.getExt(), artifact.getExtraAttributes()));
        }
        if (artifactSet.isEmpty()) {
            artifactSet.add(new DefaultIvyArtifactName(moduleName, "jar", "jar", Collections.<String, String>emptyMap()));
        }
        return artifactSet;
    }

    protected MutableModuleVersionMetaData processMetaData(MutableModuleVersionMetaData metaData) {
        return metaData;
    }

    private void checkMetadataConsistency(ModuleComponentIdentifier expectedId, ModuleVersionMetaData metadata) throws MetaDataParseException {
        ArrayList<String> errors = new ArrayList<String>();
        if (!expectedId.getGroup().equals(metadata.getId().getGroup())) {
            errors.add("bad group: expected='" + expectedId.getGroup() + "' found='" + metadata.getId().getGroup() + "'");
        }
        if (!expectedId.getModule().equals(metadata.getId().getName())) {
            errors.add("bad module name: expected='" + expectedId.getModule() + "' found='" + metadata.getId().getName() + "'");
        }
        if (!expectedId.getVersion().equals(metadata.getId().getVersion())) {
            errors.add("bad version: expected='" + expectedId.getVersion() + "' found='" + metadata.getId().getVersion() + "'");
        }
        if (errors.size() > 0) {
            throw new MetaDataParseException(String.format("inconsistent module metadata found. Descriptor: %s Errors: %s", metadata.getId(), Joiner.on((String)SystemProperties.getLineSeparator()).join(errors)));
        }
    }

    protected abstract boolean isMetaDataArtifact(ArtifactType var1);

    protected Set<ModuleVersionArtifactMetaData> findOptionalArtifacts(ModuleVersionMetaData module, String type, String classifier) {
        ModuleVersionArtifactMetaData artifact = module.artifact(type, "jar", classifier);
        if (this.createArtifactResolver(module.getSource()).artifactExists(artifact, new DefaultResourceAwareResolveResult())) {
            return ImmutableSet.of((Object)artifact);
        }
        return Collections.emptySet();
    }

    private ModuleVersionArtifactMetaData getMetaDataArtifactFor(ModuleComponentIdentifier moduleComponentIdentifier) {
        IvyArtifactName ivyArtifactName = this.getMetaDataArtifactName(moduleComponentIdentifier.getModule());
        return new DefaultModuleVersionArtifactMetaData(moduleComponentIdentifier, ivyArtifactName);
    }

    protected abstract IvyArtifactName getMetaDataArtifactName(String var1);

    protected void resolveArtifact(ComponentArtifactMetaData componentArtifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
        File localFile;
        ModuleVersionArtifactMetaData artifact = (ModuleVersionArtifactMetaData)componentArtifact;
        try {
            localFile = this.download(artifact, moduleSource, result);
        }
        catch (Throwable e) {
            result.failed(new ArtifactResolveException((ComponentArtifactIdentifier)artifact.getId(), e));
            return;
        }
        if (localFile != null) {
            result.resolved(localFile);
        } else {
            result.notFound(artifact.getId());
        }
    }

    protected File download(ModuleVersionArtifactMetaData artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
        LocallyAvailableExternalResource artifactResource = this.createArtifactResolver(moduleSource).resolveArtifact(artifact, result);
        if (artifactResource == null) {
            return null;
        }
        return artifactResource.getLocalResource().getFile();
    }

    protected ExternalResourceArtifactResolver createArtifactResolver() {
        return this.createArtifactResolver(this.ivyPatterns, this.artifactPatterns);
    }

    protected ExternalResourceArtifactResolver createArtifactResolver(List<ResourcePattern> ivyPatterns, List<ResourcePattern> artifactPatterns) {
        return new DefaultExternalResourceArtifactResolver(this.repository, this.locallyAvailableResourceFinder, ivyPatterns, artifactPatterns, this.artifactFileStore, this.cachingResourceAccessor);
    }

    protected ExternalResourceArtifactResolver createArtifactResolver(ModuleSource moduleSource) {
        return this.createArtifactResolver();
    }

    @Override
    public void publish(ModuleVersionPublishMetaData moduleVersion) throws IOException {
        for (ModuleVersionArtifactPublishMetaData artifact : moduleVersion.getArtifacts()) {
            this.publish(new DefaultModuleVersionArtifactMetaData(artifact.getId()), artifact.getFile());
        }
    }

    private void publish(ModuleVersionArtifactMetaData artifact, File src) throws IOException {
        ResourcePattern destinationPattern;
        if ("ivy".equals(artifact.getName().getType()) && !this.ivyPatterns.isEmpty()) {
            destinationPattern = this.ivyPatterns.get(0);
        } else if (!this.artifactPatterns.isEmpty()) {
            destinationPattern = this.artifactPatterns.get(0);
        } else {
            throw new IllegalStateException("impossible to publish " + artifact + " using " + this + ": no artifact pattern defined");
        }
        URI destination = destinationPattern.getLocation(artifact).getUri();
        this.put(src, destination);
        LOGGER.info("Published {} to {}", (Object)artifact, (Object)destination);
    }

    private void put(File src, URI destination) throws IOException {
        this.repository.put(src, destination);
    }

    protected void addIvyPattern(ResourcePattern pattern) {
        this.ivyPatterns.add(pattern);
    }

    protected void addArtifactPattern(ResourcePattern pattern) {
        this.artifactPatterns.add(pattern);
    }

    public List<String> getIvyPatterns() {
        return CollectionUtils.collect(this.ivyPatterns, (Transformer)new Transformer<String, ResourcePattern>(){

            public String transform(ResourcePattern original) {
                return original.getPattern();
            }
        });
    }

    public List<String> getArtifactPatterns() {
        return CollectionUtils.collect(this.artifactPatterns, (Transformer)new Transformer<String, ResourcePattern>(){

            public String transform(ResourcePattern original) {
                return original.getPattern();
            }
        });
    }

    protected void setIvyPatterns(Iterable<? extends ResourcePattern> patterns) {
        this.ivyPatterns.clear();
        CollectionUtils.addAll(this.ivyPatterns, patterns);
    }

    protected void setArtifactPatterns(List<ResourcePattern> patterns) {
        this.artifactPatterns = patterns;
    }

    public abstract boolean isM2compatible();

    protected abstract class RemoteRepositoryAccess
    extends AbstractRepositoryAccess {
        protected RemoteRepositoryAccess() {
        }

        public final void listModuleVersions(DependencyMetaData dependency, BuildableModuleVersionSelectionResolveResult result) {
            ExternalResourceResolver.this.doListModuleVersions(dependency, result);
        }

        public final void resolveComponentMetaData(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleVersionMetaDataResolveResult result) {
            ExternalResourceResolver.this.doResolveComponentMetaData(dependency, moduleComponentIdentifier, result);
        }

        public void resolveModuleArtifacts(ComponentMetaData component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            super.resolveModuleArtifacts(component, artifactType, result);
            this.checkArtifactsResolved(component, artifactType, result);
        }

        public void resolveModuleArtifacts(ComponentMetaData component, ComponentUsage componentUsage, BuildableArtifactSetResolveResult result) {
            super.resolveModuleArtifacts(component, componentUsage, result);
            this.checkArtifactsResolved(component, componentUsage, result);
        }

        private void checkArtifactsResolved(ComponentMetaData component, Object context, BuildableArtifactSetResolveResult result) {
            if (!result.hasResult()) {
                result.failed(new ArtifactResolveException(component.getComponentId(), String.format("Cannot locate %s for '%s' in repository '%s'", context, component, ExternalResourceResolver.this.name)));
            }
        }

        protected final void resolveMetaDataArtifacts(ModuleVersionMetaData module, BuildableArtifactSetResolveResult result) {
        }

        public void resolveArtifact(ComponentArtifactMetaData artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            ExternalResourceResolver.this.resolveArtifact(artifact, moduleSource, result);
        }
    }

    protected abstract class LocalRepositoryAccess
    extends AbstractRepositoryAccess {
        protected LocalRepositoryAccess() {
        }

        public final void listModuleVersions(DependencyMetaData dependency, BuildableModuleVersionSelectionResolveResult result) {
        }

        public final void resolveComponentMetaData(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleVersionMetaDataResolveResult result) {
        }

        protected final void resolveMetaDataArtifacts(ModuleVersionMetaData module, BuildableArtifactSetResolveResult result) {
            ModuleVersionArtifactMetaData artifact = ExternalResourceResolver.this.getMetaDataArtifactFor(module.getComponentId());
            result.resolved(Collections.singleton(artifact));
        }

        public void resolveArtifact(ComponentArtifactMetaData artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
        }
    }

    protected abstract class AbstractRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        protected AbstractRepositoryAccess() {
        }

        public void resolveModuleArtifacts(ComponentMetaData component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            ModuleVersionMetaData moduleMetaData = (ModuleVersionMetaData)component;
            if (artifactType == ArtifactType.JAVADOC) {
                this.resolveJavadocArtifacts(moduleMetaData, result);
            } else if (artifactType == ArtifactType.SOURCES) {
                this.resolveSourceArtifacts(moduleMetaData, result);
            } else if (ExternalResourceResolver.this.isMetaDataArtifact(artifactType)) {
                this.resolveMetaDataArtifacts(moduleMetaData, result);
            }
        }

        public void resolveModuleArtifacts(ComponentMetaData component, ComponentUsage componentUsage, BuildableArtifactSetResolveResult result) {
            String configurationName = componentUsage.getConfigurationName();
            ConfigurationMetaData configuration = component.getConfiguration(configurationName);
            this.resolveConfigurationArtifacts((ModuleVersionMetaData)component, configuration, result);
        }

        protected abstract void resolveConfigurationArtifacts(ModuleVersionMetaData var1, ConfigurationMetaData var2, BuildableArtifactSetResolveResult var3);

        protected abstract void resolveMetaDataArtifacts(ModuleVersionMetaData var1, BuildableArtifactSetResolveResult var2);

        protected abstract void resolveJavadocArtifacts(ModuleVersionMetaData var1, BuildableArtifactSetResolveResult var2);

        protected abstract void resolveSourceArtifacts(ModuleVersionMetaData var1, BuildableArtifactSetResolveResult var2);
    }
}

