/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.layout;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.artifacts.repositories.layout.RepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.resolver.PatternBasedResolver;

public class PatternRepositoryLayout
extends RepositoryLayout {
    private final Set<String> artifactPatterns = new LinkedHashSet<String>();
    private final Set<String> ivyPatterns = new LinkedHashSet<String>();
    private boolean m2compatible;

    public void artifact(String pattern) {
        this.artifactPatterns.add(pattern);
    }

    public void ivy(String pattern) {
        this.ivyPatterns.add(pattern);
    }

    public boolean getM2Compatible() {
        return this.m2compatible;
    }

    public void setM2compatible(boolean m2compatible) {
        this.m2compatible = m2compatible;
    }

    public void apply(URI baseUri, PatternBasedResolver resolver) {
        if (baseUri == null) {
            return;
        }
        resolver.setM2compatible(this.m2compatible);
        for (String artifactPattern : this.artifactPatterns) {
            resolver.addArtifactLocation(baseUri, artifactPattern);
        }
        Set<String> usedIvyPatterns = this.ivyPatterns.isEmpty() ? this.artifactPatterns : this.ivyPatterns;
        for (String ivyPattern : usedIvyPatterns) {
            resolver.addDescriptorLocation(baseUri, ivyPattern);
        }
    }
}

