/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.io.File;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ResolverStrategy;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.repositories.DefaultFlatDirArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultIvyArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenLocalArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultPasswordCredentials;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBaseRepositoryFactory
implements BaseRepositoryFactory {
    private final LocalMavenRepositoryLocator localMavenRepositoryLocator;
    private final FileResolver fileResolver;
    private final Instantiator instantiator;
    private final RepositoryTransportFactory transportFactory;
    private final LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData> locallyAvailableResourceFinder;
    private final ResolverStrategy resolverStrategy;
    private final FileStore<ModuleVersionArtifactMetaData> artifactFileStore;

    public DefaultBaseRepositoryFactory(LocalMavenRepositoryLocator localMavenRepositoryLocator, FileResolver fileResolver, Instantiator instantiator, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData> locallyAvailableResourceFinder, ResolverStrategy resolverStrategy, FileStore<ModuleVersionArtifactMetaData> artifactFileStore) {
        this.localMavenRepositoryLocator = localMavenRepositoryLocator;
        this.fileResolver = fileResolver;
        this.instantiator = instantiator;
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.resolverStrategy = resolverStrategy;
        this.artifactFileStore = artifactFileStore;
    }

    public FlatDirectoryArtifactRepository createFlatDirRepository() {
        return (FlatDirectoryArtifactRepository)this.instantiator.newInstance(DefaultFlatDirArtifactRepository.class, new Object[]{this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.resolverStrategy, this.artifactFileStore});
    }

    public MavenArtifactRepository createMavenLocalRepository() {
        MavenArtifactRepository mavenRepository = (MavenArtifactRepository)this.instantiator.newInstance(DefaultMavenLocalArtifactRepository.class, new Object[]{this.fileResolver, this.createPasswordCredentials(), this.transportFactory, this.locallyAvailableResourceFinder, this.artifactFileStore});
        File localMavenRepository = this.localMavenRepositoryLocator.getLocalMavenRepository();
        mavenRepository.setUrl((Object)localMavenRepository);
        return mavenRepository;
    }

    public MavenArtifactRepository createJCenterRepository() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository();
        mavenRepository.setUrl((Object)"http://jcenter.bintray.com/");
        return mavenRepository;
    }

    public MavenArtifactRepository createMavenCentralRepository() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository();
        mavenRepository.setUrl((Object)"http://repo1.maven.org/maven2/");
        return mavenRepository;
    }

    public IvyArtifactRepository createIvyRepository() {
        return (IvyArtifactRepository)this.instantiator.newInstance(DefaultIvyArtifactRepository.class, new Object[]{this.fileResolver, this.createPasswordCredentials(), this.transportFactory, this.locallyAvailableResourceFinder, this.instantiator, this.resolverStrategy, this.artifactFileStore});
    }

    public MavenArtifactRepository createMavenRepository() {
        return (MavenArtifactRepository)this.instantiator.newInstance(DefaultMavenArtifactRepository.class, new Object[]{this.fileResolver, this.createPasswordCredentials(), this.transportFactory, this.locallyAvailableResourceFinder, this.artifactFileStore});
    }

    private PasswordCredentials createPasswordCredentials() {
        return (PasswordCredentials)this.instantiator.newInstance(DefaultPasswordCredentials.class, new Object[0]);
    }
}

