/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.mvnsettings;

import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.artifacts.mvnsettings.CannotLocateLocalMavenRepositoryException;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.mvn3.org.apache.maven.settings.Settings;
import org.gradle.mvn3.org.apache.maven.settings.building.SettingsBuildingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocalMavenRepositoryLocator
implements LocalMavenRepositoryLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLocalMavenRepositoryLocator.class);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([^\\}]*)\\}");
    private final Map<String, String> systemProperties;
    private final Map<String, String> environmentVariables;
    private final MavenSettingsProvider settingsProvider;

    public DefaultLocalMavenRepositoryLocator(MavenSettingsProvider settingsProvider, Map<String, String> systemProperties, Map<String, String> environmentVariables) {
        this.systemProperties = systemProperties;
        this.environmentVariables = environmentVariables;
        this.settingsProvider = settingsProvider;
    }

    @Override
    public File getLocalMavenRepository() throws CannotLocateLocalMavenRepositoryException {
        try {
            Settings settings = this.settingsProvider.buildSettings();
            String repoPath = settings.getLocalRepository();
            if (repoPath != null) {
                return new File(this.resolvePlaceholders(repoPath.trim()));
            }
            File defaultLocation = new File(System.getProperty("user.home"), "/.m2/repository").getAbsoluteFile();
            LOGGER.debug(String.format("No local repository in Settings file defined. Using default path: %s", defaultLocation));
            return defaultLocation;
        }
        catch (SettingsBuildingException e) {
            throw new CannotLocateLocalMavenRepositoryException("Unable to parse local Maven settings.", e);
        }
    }

    private String resolvePlaceholders(String value) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(value);
        while (matcher.find()) {
            String replacement;
            String placeholder = matcher.group(1);
            String string = replacement = placeholder.startsWith("env.") ? this.environmentVariables.get(placeholder.substring(4)) : this.systemProperties.get(placeholder);
            if (replacement == null) {
                throw new CannotLocateLocalMavenRepositoryException(String.format("Cannot resolve placeholder '%s' in value '%s'", placeholder, value));
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

