/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.component.DefaultModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.metadata.BuildableModuleVersionPublishMetaData;
import org.gradle.api.internal.artifacts.metadata.DefaultModuleVersionArtifactIdentifier;
import org.gradle.api.internal.artifacts.metadata.IvyArtifactName;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactIdentifier;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactPublishMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleVersionPublishMetaData
implements BuildableModuleVersionPublishMetaData {
    private final ModuleVersionIdentifier id;
    private final Map<ModuleVersionArtifactIdentifier, ModuleVersionArtifactPublishMetaData> artifactsById = new LinkedHashMap<ModuleVersionArtifactIdentifier, ModuleVersionArtifactPublishMetaData>();

    public DefaultModuleVersionPublishMetaData(ModuleVersionIdentifier id) {
        this.id = id;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    public void addArtifact(Artifact artifact, File file) {
        DefaultModuleVersionArtifactPublishMetaData publishMetaData = new DefaultModuleVersionArtifactPublishMetaData(this.id, artifact, file);
        this.artifactsById.put(publishMetaData.getId(), publishMetaData);
    }

    @Override
    public void addArtifact(ModuleVersionArtifactPublishMetaData artifact) {
        this.artifactsById.put(artifact.getId(), artifact);
    }

    @Override
    public Collection<ModuleVersionArtifactPublishMetaData> getArtifacts() {
        return this.artifactsById.values();
    }

    public ModuleVersionArtifactPublishMetaData getArtifact(ModuleVersionArtifactIdentifier artifactIdentifier) {
        return this.artifactsById.get(artifactIdentifier);
    }

    private static class DefaultModuleVersionArtifactPublishMetaData
    implements ModuleVersionArtifactPublishMetaData {
        private final DefaultModuleVersionArtifactIdentifier id;
        private final Artifact artifact;
        private final File file;

        private DefaultModuleVersionArtifactPublishMetaData(ModuleVersionIdentifier moduleVersionIdentifier, Artifact artifact, File file) {
            this.id = new DefaultModuleVersionArtifactIdentifier(DefaultModuleComponentIdentifier.newId(moduleVersionIdentifier), artifact);
            this.artifact = artifact;
            this.file = file;
        }

        public IvyArtifactName getArtifactName() {
            return this.id.getName();
        }

        public Artifact toIvyArtifact() {
            return this.artifact;
        }

        public ModuleVersionArtifactIdentifier getId() {
            return this.id;
        }

        public File getFile() {
            return this.file;
        }
    }
}

