/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.metadata.AbstractModuleDescriptorBackedMetaData;
import org.gradle.api.internal.artifacts.metadata.BuildableModuleVersionPublishMetaData;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.ConfigurationMetaData;
import org.gradle.api.internal.artifacts.metadata.DefaultLocalArtifactIdentifier;
import org.gradle.api.internal.artifacts.metadata.DefaultModuleVersionPublishMetaData;
import org.gradle.api.internal.artifacts.metadata.IvyArtifactName;
import org.gradle.api.internal.artifacts.metadata.LocalArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableLocalComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocalComponentMetaData
implements MutableLocalComponentMetaData {
    private final Map<ComponentArtifactIdentifier, DefaultLocalArtifactMetaData> artifactsById = new LinkedHashMap<ComponentArtifactIdentifier, DefaultLocalArtifactMetaData>();
    private final Map<ArtifactRevisionId, DefaultLocalArtifactMetaData> artifactsByIvyId = new LinkedHashMap<ArtifactRevisionId, DefaultLocalArtifactMetaData>();
    private final Multimap<String, DefaultLocalArtifactMetaData> artifactsByConfig = LinkedHashMultimap.create();
    private final DefaultModuleDescriptor moduleDescriptor;
    private final ModuleVersionIdentifier id;
    private final ComponentIdentifier componentIdentifier;

    public DefaultLocalComponentMetaData(DefaultModuleDescriptor moduleDescriptor, ComponentIdentifier componentIdentifier) {
        this.moduleDescriptor = moduleDescriptor;
        this.id = DefaultModuleVersionIdentifier.newId(moduleDescriptor.getModuleRevisionId());
        this.componentIdentifier = componentIdentifier;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    public DefaultModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @Override
    public void addArtifact(String configuration, IvyArtifactName artifact, File file) {
        MDArtifact ivyArtifact = new MDArtifact((ModuleDescriptor)this.moduleDescriptor, artifact.getName(), artifact.getType(), artifact.getExtension(), null, artifact.getAttributes());
        DefaultLocalArtifactMetaData artifactMetaData = new DefaultLocalArtifactMetaData(this.componentIdentifier, this.id.toString(), (Artifact)ivyArtifact, file);
        if (this.artifactsById.containsKey(artifactMetaData.getId())) {
            artifactMetaData = this.artifactsById.get(artifactMetaData.getId());
        } else {
            this.artifactsById.put(artifactMetaData.id, artifactMetaData);
            this.artifactsByIvyId.put(ivyArtifact.getId(), artifactMetaData);
        }
        this.moduleDescriptor.addArtifact(configuration, (Artifact)ivyArtifact);
        this.artifactsByConfig.put((Object)configuration, (Object)artifactMetaData);
        ((MDArtifact)artifactMetaData.artifact).addConfiguration(configuration);
    }

    public Collection<? extends LocalArtifactMetaData> getArtifacts() {
        return this.artifactsById.values();
    }

    @Override
    public LocalArtifactMetaData getArtifact(ComponentArtifactIdentifier artifactIdentifier) {
        return this.artifactsById.get(artifactIdentifier);
    }

    @Override
    public ComponentMetaData toResolveMetaData() {
        return new LocalComponentResolveMetaData();
    }

    @Override
    public BuildableModuleVersionPublishMetaData toPublishMetaData() {
        DefaultModuleVersionPublishMetaData publishMetaData = new DefaultModuleVersionPublishMetaData(this.id);
        for (DefaultLocalArtifactMetaData artifact : this.artifactsById.values()) {
            publishMetaData.addArtifact(artifact.artifact, artifact.file);
        }
        return publishMetaData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalComponentResolveMetaData
    extends AbstractModuleDescriptorBackedMetaData {
        public LocalComponentResolveMetaData() {
            super(DefaultLocalComponentMetaData.this.id, (ModuleDescriptor)DefaultLocalComponentMetaData.this.moduleDescriptor, DefaultLocalComponentMetaData.this.componentIdentifier);
        }

        public MutableModuleVersionMetaData copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ModuleVersionMetaData withSource(ModuleSource source) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ComponentArtifactMetaData artifact(Artifact artifact) {
            DefaultLocalArtifactMetaData candidate = (DefaultLocalArtifactMetaData)DefaultLocalComponentMetaData.this.artifactsByIvyId.get(artifact.getId());
            return candidate != null ? candidate : new DefaultLocalArtifactMetaData(DefaultLocalComponentMetaData.this.componentIdentifier, DefaultLocalComponentMetaData.this.id.toString(), artifact, null);
        }

        public Set<ComponentArtifactMetaData> getArtifacts() {
            return new LinkedHashSet<ComponentArtifactMetaData>(DefaultLocalComponentMetaData.this.artifactsById.values());
        }

        @Override
        protected Set<ComponentArtifactMetaData> getArtifactsForConfiguration(ConfigurationMetaData configurationMetaData) {
            LinkedHashSet<ComponentArtifactMetaData> result = new LinkedHashSet<ComponentArtifactMetaData>();
            HashSet<DefaultLocalArtifactIdentifier> seen = new HashSet<DefaultLocalArtifactIdentifier>();
            for (String configName : configurationMetaData.getHierarchy()) {
                for (DefaultLocalArtifactMetaData localArtifactMetaData : DefaultLocalComponentMetaData.this.artifactsByConfig.get((Object)configName)) {
                    if (!seen.add(localArtifactMetaData.id)) continue;
                    result.add(localArtifactMetaData);
                }
            }
            return result;
        }
    }

    private static class DefaultLocalArtifactMetaData
    implements LocalArtifactMetaData {
        private final ComponentIdentifier componentIdentifier;
        private final DefaultLocalArtifactIdentifier id;
        private final Artifact artifact;
        private final File file;

        private DefaultLocalArtifactMetaData(ComponentIdentifier componentIdentifier, String displayName, Artifact artifact, File file) {
            this.componentIdentifier = componentIdentifier;
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.putAll(artifact.getExtraAttributes());
            attrs.put("file", file == null ? "null" : file.getAbsolutePath());
            this.id = new DefaultLocalArtifactIdentifier(componentIdentifier, displayName, artifact.getName(), artifact.getType(), artifact.getExt(), attrs);
            this.artifact = artifact;
            this.file = file;
        }

        public String toString() {
            return this.id.toString();
        }

        public IvyArtifactName getName() {
            return this.id.getName();
        }

        public ComponentIdentifier getComponentId() {
            return this.componentIdentifier;
        }

        public ComponentArtifactIdentifier getId() {
            return this.id;
        }

        public File getFile() {
            return this.file;
        }
    }
}

