/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.ConfigurationMetaData;
import org.gradle.api.internal.artifacts.metadata.DefaultDependencyMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModuleDescriptorBackedMetaData
implements ComponentMetaData {
    private static final List<String> DEFAULT_STATUS_SCHEME = Arrays.asList("integration", "milestone", "release");
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final ModuleDescriptor moduleDescriptor;
    private final ComponentIdentifier componentIdentifier;
    private ModuleSource moduleSource;
    private boolean changing;
    private String status;
    private List<String> statusScheme = DEFAULT_STATUS_SCHEME;
    private List<DependencyMetaData> dependencies;
    private Map<String, DefaultConfigurationMetaData> configurations = new HashMap<String, DefaultConfigurationMetaData>();

    public AbstractModuleDescriptorBackedMetaData(ModuleVersionIdentifier moduleVersionIdentifier, ModuleDescriptor moduleDescriptor, ComponentIdentifier componentIdentifier) {
        this.moduleVersionIdentifier = moduleVersionIdentifier;
        this.moduleDescriptor = moduleDescriptor;
        this.componentIdentifier = componentIdentifier;
        this.status = moduleDescriptor.getStatus();
    }

    protected void copyTo(AbstractModuleDescriptorBackedMetaData copy) {
        copy.dependencies = this.dependencies;
        copy.changing = this.changing;
        copy.status = this.status;
        copy.statusScheme = this.statusScheme;
        copy.moduleSource = this.moduleSource;
    }

    public String toString() {
        return this.moduleVersionIdentifier.toString();
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.moduleVersionIdentifier;
    }

    @Override
    public ModuleSource getSource() {
        return this.moduleSource;
    }

    public void setModuleSource(ModuleSource moduleSource) {
        this.moduleSource = moduleSource;
    }

    @Override
    public ModuleDescriptor getDescriptor() {
        return this.moduleDescriptor;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public ComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    public void setChanging(boolean changing) {
        this.changing = changing;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatusScheme(List<String> statusScheme) {
        this.statusScheme = statusScheme;
    }

    @Override
    public List<DependencyMetaData> getDependencies() {
        if (this.dependencies == null) {
            this.populateDependenciesFromDescriptor();
        }
        return this.dependencies;
    }

    private void populateDependenciesFromDescriptor() {
        this.dependencies = new ArrayList<DependencyMetaData>();
        for (DependencyDescriptor dependencyDescriptor : this.moduleDescriptor.getDependencies()) {
            this.dependencies.add(new DefaultDependencyMetaData(dependencyDescriptor));
        }
    }

    public void setDependencies(Iterable<? extends DependencyMetaData> dependencies) {
        this.dependencies = CollectionUtils.toList(dependencies);
        for (DefaultConfigurationMetaData configuration : this.configurations.values()) {
            configuration.dependencies = null;
        }
    }

    @Override
    public DefaultConfigurationMetaData getConfiguration(String name) {
        DefaultConfigurationMetaData configuration = this.configurations.get(name);
        if (configuration == null) {
            configuration = this.populateConfigurationFromDescriptor(name);
        }
        return configuration;
    }

    private DefaultConfigurationMetaData populateConfigurationFromDescriptor(String name) {
        Configuration descriptorConfiguration = this.moduleDescriptor.getConfiguration(name);
        if (descriptorConfiguration == null) {
            return null;
        }
        LinkedHashSet<String> hierarchy = new LinkedHashSet<String>();
        hierarchy.add(name);
        for (String parent : descriptorConfiguration.getExtends()) {
            hierarchy.addAll(this.getConfiguration(parent).hierarchy);
        }
        DefaultConfigurationMetaData configuration = new DefaultConfigurationMetaData(name, descriptorConfiguration, hierarchy);
        this.configurations.put(name, configuration);
        return configuration;
    }

    protected abstract Set<ComponentArtifactMetaData> getArtifactsForConfiguration(ConfigurationMetaData var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultConfigurationMetaData
    implements ConfigurationMetaData {
        private final String name;
        private final Configuration descriptor;
        private final Set<String> hierarchy;
        private List<DependencyMetaData> dependencies;
        private Set<ComponentArtifactMetaData> artifacts;
        private LinkedHashSet<ExcludeRule> excludeRules;

        private DefaultConfigurationMetaData(String name, Configuration descriptor, Set<String> hierarchy) {
            this.name = name;
            this.descriptor = descriptor;
            this.hierarchy = hierarchy;
        }

        public String toString() {
            return String.format("%s:%s", AbstractModuleDescriptorBackedMetaData.this.moduleVersionIdentifier, this.name);
        }

        @Override
        public ComponentMetaData getComponent() {
            return AbstractModuleDescriptorBackedMetaData.this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<String> getHierarchy() {
            return this.hierarchy;
        }

        @Override
        public boolean isTransitive() {
            return this.descriptor.isTransitive();
        }

        @Override
        public List<DependencyMetaData> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<DependencyMetaData>();
                for (DependencyMetaData dependency : AbstractModuleDescriptorBackedMetaData.this.getDependencies()) {
                    if (!this.include(dependency)) continue;
                    this.dependencies.add(dependency);
                }
            }
            return this.dependencies;
        }

        private boolean include(DependencyMetaData dependency) {
            String[] moduleConfigurations = dependency.getDescriptor().getModuleConfigurations();
            for (int i = 0; i < moduleConfigurations.length; ++i) {
                String moduleConfiguration = moduleConfigurations[i];
                if (moduleConfiguration.equals("%") || this.hierarchy.contains(moduleConfiguration)) {
                    return true;
                }
                if (!moduleConfiguration.equals("*")) continue;
                boolean include = true;
                for (int j = i + 1; j < moduleConfigurations.length && moduleConfigurations[j].startsWith("!"); ++j) {
                    if (!moduleConfigurations[j].substring(1).equals(this.getName())) continue;
                    include = false;
                    break;
                }
                if (!include) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<ExcludeRule> getExcludeRules() {
            if (this.excludeRules == null) {
                this.populateExcludeRulesFromDescriptor();
            }
            return this.excludeRules;
        }

        private void populateExcludeRulesFromDescriptor() {
            this.excludeRules = new LinkedHashSet();
            block0: for (ExcludeRule excludeRule : AbstractModuleDescriptorBackedMetaData.this.moduleDescriptor.getAllExcludeRules()) {
                for (String config : excludeRule.getConfigurations()) {
                    if (!this.hierarchy.contains(config)) continue;
                    this.excludeRules.add(excludeRule);
                    continue block0;
                }
            }
        }

        @Override
        public Set<ComponentArtifactMetaData> getArtifacts() {
            if (this.artifacts == null) {
                this.artifacts = AbstractModuleDescriptorBackedMetaData.this.getArtifactsForConfiguration(this);
            }
            return this.artifacts;
        }
    }
}

