/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.InternalDependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.InternalDependencyResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ModuleVersionSelection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ModuleVersionSelectionSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolutionResultBuilder;
import org.gradle.api.internal.artifacts.result.DefaultResolutionResult;
import org.gradle.api.internal.cache.BinaryStore;
import org.gradle.api.internal.cache.Store;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingResolutionResultBuilder
implements ResolutionResultBuilder {
    private static final byte ROOT = 1;
    private static final byte MODULE = 2;
    private static final byte DEPENDENCY = 3;
    private static final byte DONE = 4;
    private final Map<ComponentSelector, ModuleVersionResolveException> failures = new HashMap<ComponentSelector, ModuleVersionResolveException>();
    private final BinaryStore store;
    private final ModuleVersionIdentifierSerializer moduleVersionIdentifierSerializer = new ModuleVersionIdentifierSerializer();
    private final ModuleVersionSelectionSerializer moduleVersionSelectionSerializer = new ModuleVersionSelectionSerializer();
    private final Store<ResolvedComponentResult> cache;
    private final InternalDependencyResultSerializer internalDependencyResultSerializer = new InternalDependencyResultSerializer();
    private final ComponentIdentifierSerializer componentIdentifierSerializer = new ComponentIdentifierSerializer();
    Set<ModuleVersionIdentifier> visitedModules = new HashSet<ModuleVersionIdentifier>();

    public StreamingResolutionResultBuilder(BinaryStore store, Store<ResolvedComponentResult> cache) {
        this.store = store;
        this.cache = cache;
    }

    @Override
    public ResolutionResult complete() {
        this.store.write(new BinaryStore.WriteAction(){

            public void write(Encoder encoder) throws IOException {
                encoder.writeByte((byte)4);
            }
        });
        BinaryStore.BinaryData data = this.store.done();
        RootFactory rootSource = new RootFactory(data, this.failures, this.cache);
        return new DefaultResolutionResult(rootSource);
    }

    @Override
    public ResolutionResultBuilder start(final ModuleVersionIdentifier root, final ComponentIdentifier componentIdentifier) {
        this.store.write(new BinaryStore.WriteAction(){

            public void write(Encoder encoder) throws IOException {
                encoder.writeByte((byte)1);
                StreamingResolutionResultBuilder.this.moduleVersionIdentifierSerializer.write(encoder, root);
                StreamingResolutionResultBuilder.this.componentIdentifierSerializer.write(encoder, componentIdentifier);
            }
        });
        return this;
    }

    @Override
    public void resolvedModuleVersion(final ModuleVersionSelection moduleVersion) {
        if (this.visitedModules.add(moduleVersion.getSelectedId())) {
            this.store.write(new BinaryStore.WriteAction(){

                public void write(Encoder encoder) throws IOException {
                    encoder.writeByte((byte)2);
                    StreamingResolutionResultBuilder.this.moduleVersionSelectionSerializer.write(encoder, moduleVersion);
                }
            });
        }
    }

    @Override
    public void resolvedConfiguration(final ModuleVersionIdentifier from, final Collection<? extends InternalDependencyResult> dependencies) {
        if (!dependencies.isEmpty()) {
            this.store.write(new BinaryStore.WriteAction(){

                public void write(Encoder encoder) throws IOException {
                    encoder.writeByte((byte)3);
                    StreamingResolutionResultBuilder.this.moduleVersionIdentifierSerializer.write(encoder, from);
                    encoder.writeSmallInt(dependencies.size());
                    for (InternalDependencyResult dependency : dependencies) {
                        StreamingResolutionResultBuilder.this.internalDependencyResultSerializer.write(encoder, dependency);
                        if (dependency.getFailure() == null) continue;
                        StreamingResolutionResultBuilder.this.failures.put(dependency.getRequested(), dependency.getFailure());
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootFactory
    implements Factory<ResolvedComponentResult> {
        private static final Logger LOG = Logging.getLogger(RootFactory.class);
        private final ModuleVersionSelectionSerializer moduleVersionSelectionSerializer = new ModuleVersionSelectionSerializer();
        private final BinaryStore.BinaryData data;
        private final Map<ComponentSelector, ModuleVersionResolveException> failures;
        private final Store<ResolvedComponentResult> cache;
        private final Object lock = new Object();
        private final ModuleVersionIdentifierSerializer moduleVersionIdentifierSerializer = new ModuleVersionIdentifierSerializer();
        private final InternalDependencyResultSerializer internalDependencyResultSerializer = new InternalDependencyResultSerializer();
        private final ComponentIdentifierSerializer componentIdentifierSerializer = new ComponentIdentifierSerializer();

        public RootFactory(BinaryStore.BinaryData data, Map<ComponentSelector, ModuleVersionResolveException> failures, Store<ResolvedComponentResult> cache) {
            this.data = data;
            this.failures = failures;
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResolvedComponentResult create() {
            Object object = this.lock;
            synchronized (object) {
                return (ResolvedComponentResult)this.cache.load((Factory)new Factory<ResolvedComponentResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public ResolvedComponentResult create() {
                        try {
                            ResolvedComponentResult resolvedComponentResult = (ResolvedComponentResult)RootFactory.this.data.read((BinaryStore.ReadAction)new BinaryStore.ReadAction<ResolvedComponentResult>(){

                                public ResolvedComponentResult read(Decoder decoder) throws IOException {
                                    return RootFactory.this.deserialize(decoder);
                                }
                            });
                            return resolvedComponentResult;
                        }
                        finally {
                            try {
                                RootFactory.this.data.close();
                            }
                            catch (IOException e) {
                                throw UncheckedException.throwAsUncheckedException((Throwable)e);
                            }
                        }
                    }
                });
            }
        }

        private ResolvedComponentResult deserialize(Decoder decoder) {
            int valuesRead = 0;
            int type = -1;
            Clock clock = new Clock();
            try {
                DefaultResolutionResultBuilder builder = new DefaultResolutionResultBuilder();
                block8: while (true) {
                    type = decoder.readByte();
                    ++valuesRead;
                    switch (type) {
                        case 1: {
                            ModuleVersionIdentifier id = this.moduleVersionIdentifierSerializer.read(decoder);
                            ComponentIdentifier componentIdentifier = this.componentIdentifierSerializer.read(decoder);
                            builder.start(id, componentIdentifier);
                            continue block8;
                        }
                        case 2: {
                            ModuleVersionSelection sel = this.moduleVersionSelectionSerializer.read(decoder);
                            builder.resolvedModuleVersion(sel);
                            continue block8;
                        }
                        case 3: {
                            ModuleVersionIdentifier id = this.moduleVersionIdentifierSerializer.read(decoder);
                            int size = decoder.readSmallInt();
                            LinkedList<InternalDependencyResult> deps = new LinkedList<InternalDependencyResult>();
                            for (int i = 0; i < size; ++i) {
                                deps.add(this.internalDependencyResultSerializer.read(decoder, this.failures));
                            }
                            builder.resolvedConfiguration(id, deps);
                            continue block8;
                        }
                        case 4: {
                            ResolvedComponentResult root = builder.complete().getRoot();
                            LOG.debug("Loaded resolution results ({}) from {}", (Object)clock.getTime(), (Object)this.data);
                            return root;
                        }
                    }
                    break;
                }
                throw new IOException("Unknown value type read from stream: " + type);
            }
            catch (IOException e) {
                throw new RuntimeException("Problems loading the resolution results (" + clock.getTime() + "). " + "Read " + valuesRead + " values, last was: " + type, e);
            }
        }
    }
}

