/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.CachingDependencyResultFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.InternalDependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ModuleVersionSelection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.api.internal.artifacts.result.DefaultResolutionResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolutionResultBuilder
implements ResolutionResultBuilder {
    private DefaultResolvedComponentResult rootModule;
    private Map<ModuleVersionIdentifier, DefaultResolvedComponentResult> modules = new LinkedHashMap<ModuleVersionIdentifier, DefaultResolvedComponentResult>();
    CachingDependencyResultFactory dependencyResultFactory = new CachingDependencyResultFactory();

    @Override
    public DefaultResolutionResultBuilder start(ModuleVersionIdentifier root, ComponentIdentifier componentIdentifier) {
        this.rootModule = this.createOrGet(root, VersionSelectionReasons.ROOT, componentIdentifier);
        return this;
    }

    @Override
    public ResolutionResult complete() {
        return new DefaultResolutionResult(new RootFactory(this.rootModule));
    }

    @Override
    public void resolvedModuleVersion(ModuleVersionSelection moduleVersion) {
        this.createOrGet(moduleVersion.getSelectedId(), moduleVersion.getSelectionReason(), moduleVersion.getComponentId());
    }

    @Override
    public void resolvedConfiguration(ModuleVersionIdentifier id, Collection<? extends InternalDependencyResult> dependencies) {
        for (InternalDependencyResult internalDependencyResult : dependencies) {
            UnresolvedDependencyResult dependency;
            DefaultResolvedComponentResult from = this.modules.get(id);
            if (internalDependencyResult.getFailure() != null) {
                dependency = this.dependencyResultFactory.createUnresolvedDependency(internalDependencyResult.getRequested(), from, internalDependencyResult.getReason(), internalDependencyResult.getFailure());
            } else {
                DefaultResolvedComponentResult selected = this.modules.get(internalDependencyResult.getSelected());
                dependency = this.dependencyResultFactory.createResolvedDependency(internalDependencyResult.getRequested(), from, selected);
                selected.addDependent((ResolvedDependencyResult)dependency);
            }
            from.addDependency((DependencyResult)dependency);
        }
    }

    private DefaultResolvedComponentResult createOrGet(ModuleVersionIdentifier id, ComponentSelectionReason selectionReason, ComponentIdentifier componentId) {
        if (!this.modules.containsKey(id)) {
            this.modules.put(id, new DefaultResolvedComponentResult(id, selectionReason, componentId));
        }
        return this.modules.get(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootFactory
    implements Factory<ResolvedComponentResult> {
        private DefaultResolvedComponentResult rootModule;

        public RootFactory(DefaultResolvedComponentResult rootModule) {
            this.rootModule = rootModule;
        }

        public ResolvedComponentResult create() {
            return this.rootModule;
        }
    }
}

