/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.DefaultUnresolvedDependency;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedConfigurationBuilder;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResolvedConfigurationDependencyGraphVisitor
implements DependencyGraphVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolvedConfigurationDependencyGraphVisitor.class);
    private final ResolvedConfigurationBuilder builder;
    private final ArtifactResolver artifactResolver;
    private final Map<ModuleVersionSelector, BrokenDependency> failuresByRevisionId = new LinkedHashMap<ModuleVersionSelector, BrokenDependency>();
    private DependencyGraphBuilder.ConfigurationNode root;

    ResolvedConfigurationDependencyGraphVisitor(ResolvedConfigurationBuilder builder, ArtifactResolver artifactResolver) {
        this.builder = builder;
        this.artifactResolver = artifactResolver;
    }

    @Override
    public void start(DependencyGraphBuilder.ConfigurationNode root) {
        this.root = root;
    }

    @Override
    public void visitNode(DependencyGraphBuilder.ConfigurationNode resolvedConfiguration) {
        this.builder.newResolvedDependency(resolvedConfiguration.id);
        for (DependencyGraphBuilder.DependencyEdge dependency : resolvedConfiguration.outgoingEdges) {
            ModuleVersionResolveException failure = dependency.getFailure();
            if (failure == null) continue;
            this.addUnresolvedDependency(dependency, dependency.getRequestedModuleVersion(), failure);
        }
    }

    @Override
    public void visitEdge(DependencyGraphBuilder.ConfigurationNode resolvedConfiguration) {
        LOGGER.debug("Attaching {} to its parents.", (Object)resolvedConfiguration);
        for (DependencyGraphBuilder.DependencyEdge dependency : resolvedConfiguration.incomingEdges) {
            this.attachToParents(dependency, resolvedConfiguration, this.builder);
        }
    }

    private void attachToParents(DependencyGraphBuilder.DependencyEdge dependency, DependencyGraphBuilder.ConfigurationNode childConfiguration, ResolvedConfigurationBuilder oldModelBuilder) {
        ResolvedConfigurationIdentifier parent = dependency.from.id;
        ResolvedConfigurationIdentifier child = childConfiguration.id;
        oldModelBuilder.addChild(parent, child);
        oldModelBuilder.addParentSpecificArtifacts(child, parent, this.getArtifacts(dependency, childConfiguration, oldModelBuilder));
        if (parent == this.root.id) {
            ModuleDependency moduleDependency = dependency.getModuleDependency();
            oldModelBuilder.addFirstLevelDependency(moduleDependency, child);
        }
    }

    private Set<ResolvedArtifact> getArtifacts(DependencyGraphBuilder.DependencyEdge dependency, DependencyGraphBuilder.ConfigurationNode childConfiguration, ResolvedConfigurationBuilder builder) {
        Set<ComponentArtifactMetaData> dependencyArtifacts = dependency.getArtifacts(childConfiguration.metaData);
        if (dependencyArtifacts.isEmpty()) {
            return childConfiguration.getArtifacts(builder);
        }
        LinkedHashSet<ResolvedArtifact> artifacts = new LinkedHashSet<ResolvedArtifact>();
        for (ComponentArtifactMetaData artifact : dependencyArtifacts) {
            artifacts.add(builder.newArtifact(childConfiguration.id, childConfiguration.metaData.getComponent(), artifact, this.artifactResolver));
        }
        return artifacts;
    }

    @Override
    public void finish(DependencyGraphBuilder.ConfigurationNode root) {
        this.attachFailures(this.builder);
        this.builder.done(root.id);
    }

    private void attachFailures(ResolvedConfigurationBuilder result) {
        for (Map.Entry<ModuleVersionSelector, BrokenDependency> entry : this.failuresByRevisionId.entrySet()) {
            Collection<List<ModuleVersionIdentifier>> paths = this.calculatePaths(entry.getValue());
            result.addUnresolvedDependency(new DefaultUnresolvedDependency(entry.getKey(), (Throwable)((Object)entry.getValue().failure.withIncomingPaths(paths))));
        }
    }

    private Collection<List<ModuleVersionIdentifier>> calculatePaths(BrokenDependency brokenDependency) {
        LinkedHashMap shortestPaths = new LinkedHashMap();
        ArrayList<ModuleVersionIdentifier> rootPath = new ArrayList<ModuleVersionIdentifier>();
        rootPath.add(this.root.toId());
        shortestPaths.put(this.root.moduleRevision, rootPath);
        LinkedHashSet<DependencyGraphBuilder.ModuleVersionResolveState> directDependees = new LinkedHashSet<DependencyGraphBuilder.ModuleVersionResolveState>();
        for (DependencyGraphBuilder.ConfigurationNode node : brokenDependency.requiredBy) {
            directDependees.add(node.moduleRevision);
        }
        HashSet<DependencyGraphBuilder.ModuleVersionResolveState> seen = new HashSet<DependencyGraphBuilder.ModuleVersionResolveState>();
        LinkedList<DependencyGraphBuilder.ModuleVersionResolveState> queue = new LinkedList<DependencyGraphBuilder.ModuleVersionResolveState>();
        queue.addAll(directDependees);
        while (!queue.isEmpty()) {
            DependencyGraphBuilder.ModuleVersionResolveState version = (DependencyGraphBuilder.ModuleVersionResolveState)queue.getFirst();
            if (version == this.root.moduleRevision) {
                queue.removeFirst();
                continue;
            }
            if (seen.add(version)) {
                for (DependencyGraphBuilder.ModuleVersionResolveState incomingVersion : version.getIncoming()) {
                    queue.add(0, incomingVersion);
                }
                continue;
            }
            queue.remove();
            List shortest = null;
            for (DependencyGraphBuilder.ModuleVersionResolveState incomingVersion : version.getIncoming()) {
                List candidate = (List)shortestPaths.get(incomingVersion);
                if (candidate == null) continue;
                if (shortest == null) {
                    shortest = candidate;
                    continue;
                }
                if (shortest.size() <= candidate.size()) continue;
                shortest = candidate;
            }
            if (shortest == null) continue;
            ArrayList<ModuleVersionIdentifier> path = new ArrayList<ModuleVersionIdentifier>();
            path.addAll(shortest);
            path.add(version.id);
            shortestPaths.put(version, path);
        }
        ArrayList<List<ModuleVersionIdentifier>> paths = new ArrayList<List<ModuleVersionIdentifier>>();
        for (DependencyGraphBuilder.ModuleVersionResolveState version : directDependees) {
            List path = (List)shortestPaths.get(version);
            paths.add(path);
        }
        return paths;
    }

    private void addUnresolvedDependency(DependencyGraphBuilder.DependencyEdge dependency, ModuleVersionSelector requested, ModuleVersionResolveException failure) {
        BrokenDependency breakage = this.failuresByRevisionId.get(requested);
        if (breakage == null) {
            breakage = new BrokenDependency(failure);
            this.failuresByRevisionId.put(requested, breakage);
        }
        breakage.requiredBy.add(dependency.from);
    }

    private static class BrokenDependency {
        final ModuleVersionResolveException failure;
        final List<DependencyGraphBuilder.ConfigurationNode> requiredBy = new ArrayList<DependencyGraphBuilder.ConfigurationNode>();

        private BrokenDependency(ModuleVersionResolveException failure) {
            this.failure = failure;
        }
    }
}

