/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleVersionSpec
implements Spec<ModuleId> {
    private static final AcceptAllSpec ALL_SPEC = new AcceptAllSpec();

    public static ModuleVersionSpec forExcludes(ExcludeRule ... excludeRules) {
        return ModuleVersionSpec.forExcludes(Arrays.asList(excludeRules));
    }

    public static ModuleVersionSpec forExcludes(Collection<ExcludeRule> excludeRules) {
        if (excludeRules.isEmpty()) {
            return ALL_SPEC;
        }
        return new ExcludeRuleBackedSpec(excludeRules);
    }

    public final ModuleVersionSpec union(ModuleVersionSpec other) {
        if (other == this) {
            return this;
        }
        if (other == ALL_SPEC) {
            return other;
        }
        if (this == ALL_SPEC) {
            return this;
        }
        ArrayList<ModuleVersionSpec> specs = new ArrayList<ModuleVersionSpec>();
        this.unpackUnion(specs);
        other.unpackUnion(specs);
        int i = 0;
        while (i < specs.size()) {
            ModuleVersionSpec spec = (ModuleVersionSpec)specs.get(i);
            ModuleVersionSpec merged = null;
            for (int j = i + 1; j < specs.size(); ++j) {
                merged = spec.doUnion((ModuleVersionSpec)specs.get(j));
                if (merged == null) continue;
                specs.remove(j);
                break;
            }
            if (merged != null) {
                specs.set(i, merged);
                continue;
            }
            ++i;
        }
        if (specs.size() == 1) {
            return (ModuleVersionSpec)specs.get(0);
        }
        return new UnionSpec(specs);
    }

    protected void unpackUnion(Collection<ModuleVersionSpec> specs) {
        specs.add(this);
    }

    protected ModuleVersionSpec doUnion(ModuleVersionSpec other) {
        return null;
    }

    public final boolean acceptsSameModulesAs(ModuleVersionSpec other) {
        if (other == this) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        return this.doAcceptsSameModulesAs(other);
    }

    protected boolean doAcceptsSameModulesAs(ModuleVersionSpec other) {
        return false;
    }

    public final ModuleVersionSpec intersect(ModuleVersionSpec other) {
        if (other == this) {
            return this;
        }
        if (other == ALL_SPEC) {
            return this;
        }
        if (this == ALL_SPEC) {
            return other;
        }
        return this.doIntersection(other);
    }

    protected ModuleVersionSpec doIntersection(ModuleVersionSpec other) {
        return new IntersectSpec(new ModuleVersionSpec[]{this, other});
    }

    private static class ExcludeRuleSpec
    extends ModuleVersionSpec {
        private final ExcludeRule rule;

        private ExcludeRuleSpec(ExcludeRule rule) {
            this.rule = rule;
        }

        public String toString() {
            return String.format("{exclude-rule %s}", this.rule);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ExcludeRuleSpec other = (ExcludeRuleSpec)o;
            return this.rule == other.rule;
        }

        public int hashCode() {
            return this.rule.hashCode();
        }

        protected boolean doAcceptsSameModulesAs(ModuleVersionSpec other) {
            ExcludeRuleSpec excludeRuleSpec = (ExcludeRuleSpec)other;
            return this.rule == excludeRuleSpec.rule;
        }

        public boolean isSatisfiedBy(ModuleId element) {
            return MatcherHelper.matches((PatternMatcher)this.rule.getMatcher(), (ModuleId)this.rule.getId().getModuleId(), (ModuleId)element);
        }
    }

    private static class GroupNameSpec
    extends ModuleVersionSpec {
        private final String group;

        private GroupNameSpec(String group) {
            this.group = group;
        }

        public String toString() {
            return String.format("{group %s}", this.group);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            GroupNameSpec other = (GroupNameSpec)o;
            return this.group.equals(other.group);
        }

        public int hashCode() {
            return this.group.hashCode();
        }

        public boolean doAcceptsSameModulesAs(ModuleVersionSpec other) {
            GroupNameSpec groupNameSpec = (GroupNameSpec)other;
            return this.group.equals(groupNameSpec.group);
        }

        public boolean isSatisfiedBy(ModuleId element) {
            return element.getOrganisation().equals(this.group);
        }
    }

    private static class ModuleNameSpec
    extends ModuleVersionSpec {
        private final String module;

        private ModuleNameSpec(String module) {
            this.module = module;
        }

        public String toString() {
            return String.format("{module %s}", this.module);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ModuleNameSpec other = (ModuleNameSpec)o;
            return this.module.equals(other.module);
        }

        public int hashCode() {
            return this.module.hashCode();
        }

        public boolean doAcceptsSameModulesAs(ModuleVersionSpec other) {
            ModuleNameSpec moduleNameSpec = (ModuleNameSpec)other;
            return this.module.equals(moduleNameSpec.module);
        }

        public boolean isSatisfiedBy(ModuleId element) {
            return element.getName().equals(this.module);
        }
    }

    private static class ModuleIdSpec
    extends ModuleVersionSpec {
        private final ModuleId moduleId;

        private ModuleIdSpec(ModuleId moduleId) {
            this.moduleId = moduleId;
        }

        public String toString() {
            return String.format("{module-id %s}", this.moduleId);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ModuleIdSpec other = (ModuleIdSpec)o;
            return this.moduleId.equals((Object)other.moduleId);
        }

        public int hashCode() {
            return this.moduleId.hashCode();
        }

        protected boolean doAcceptsSameModulesAs(ModuleVersionSpec other) {
            ModuleIdSpec moduleIdSpec = (ModuleIdSpec)other;
            return this.moduleId.equals((Object)moduleIdSpec.moduleId);
        }

        public boolean isSatisfiedBy(ModuleId element) {
            return element.equals((Object)this.moduleId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntersectSpec
    extends CompositeSpec {
        private final List<ModuleVersionSpec> specs;

        private IntersectSpec(ModuleVersionSpec ... specs) {
            this.specs = Arrays.asList(specs);
        }

        @Override
        Collection<ModuleVersionSpec> getSpecs() {
            return this.specs;
        }

        public boolean isSatisfiedBy(ModuleId element) {
            for (ModuleVersionSpec spec : this.specs) {
                if (spec.isSatisfiedBy(element)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnionSpec
    extends CompositeSpec {
        private final List<ModuleVersionSpec> specs;

        public UnionSpec(List<ModuleVersionSpec> specs) {
            this.specs = specs;
        }

        @Override
        Collection<ModuleVersionSpec> getSpecs() {
            return this.specs;
        }

        @Override
        protected void unpackUnion(Collection<ModuleVersionSpec> specs) {
            specs.addAll(this.specs);
        }

        public boolean isSatisfiedBy(ModuleId element) {
            for (ModuleVersionSpec spec : this.specs) {
                if (!spec.isSatisfiedBy(element)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExcludeRuleBackedSpec
    extends CompositeSpec {
        private final Set<ModuleVersionSpec> excludeSpecs = new HashSet<ModuleVersionSpec>();

        private ExcludeRuleBackedSpec(Iterable<ExcludeRule> excludeRules) {
            for (ExcludeRule rule : excludeRules) {
                if (!(rule.getMatcher() instanceof ExactPatternMatcher)) {
                    this.excludeSpecs.add(new ExcludeRuleSpec(rule));
                    continue;
                }
                ModuleId moduleId = rule.getId().getModuleId();
                boolean wildcardGroup = "*".equals(moduleId.getOrganisation());
                boolean wildcardModule = "*".equals(moduleId.getName());
                if (wildcardGroup && wildcardModule) {
                    this.excludeSpecs.add(new ExcludeRuleSpec(rule));
                    continue;
                }
                if (wildcardGroup) {
                    this.excludeSpecs.add(new ModuleNameSpec(moduleId.getName()));
                    continue;
                }
                if (wildcardModule) {
                    this.excludeSpecs.add(new GroupNameSpec(moduleId.getOrganisation()));
                    continue;
                }
                this.excludeSpecs.add(new ModuleIdSpec(moduleId));
            }
        }

        public ExcludeRuleBackedSpec(Collection<ModuleVersionSpec> specs) {
            this.excludeSpecs.addAll(specs);
        }

        @Override
        Collection<ModuleVersionSpec> getSpecs() {
            return this.excludeSpecs;
        }

        public boolean isSatisfiedBy(ModuleId element) {
            for (ModuleVersionSpec excludeSpec : this.excludeSpecs) {
                if (!excludeSpec.isSatisfiedBy(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected ModuleVersionSpec doUnion(ModuleVersionSpec other) {
            if (!(other instanceof ExcludeRuleBackedSpec)) {
                return super.doUnion(other);
            }
            ExcludeRuleBackedSpec excludeRuleBackedSpec = (ExcludeRuleBackedSpec)other;
            if (this.excludeSpecs.equals(excludeRuleBackedSpec.excludeSpecs)) {
                return this;
            }
            for (ModuleVersionSpec excludeSpec : this.excludeSpecs) {
                if (!(excludeSpec instanceof ExcludeRuleSpec)) continue;
                return super.doUnion(other);
            }
            for (ModuleVersionSpec excludeSpec : excludeRuleBackedSpec.excludeSpecs) {
                if (!(excludeSpec instanceof ExcludeRuleSpec)) continue;
                return super.doUnion(other);
            }
            ArrayList<ModuleVersionSpec> merged = new ArrayList<ModuleVersionSpec>();
            for (ModuleVersionSpec thisSpec : this.excludeSpecs) {
                for (ModuleVersionSpec otherSpec : excludeRuleBackedSpec.excludeSpecs) {
                    this.intersect(thisSpec, otherSpec, merged);
                }
            }
            if (merged.isEmpty()) {
                return ALL_SPEC;
            }
            return new ExcludeRuleBackedSpec((Collection<ModuleVersionSpec>)merged);
        }

        private void intersect(ModuleVersionSpec spec1, ModuleVersionSpec spec2, List<ModuleVersionSpec> merged) {
            if (spec1 instanceof GroupNameSpec) {
                this.intersect((GroupNameSpec)spec1, spec2, merged);
            } else if (spec2 instanceof GroupNameSpec) {
                this.intersect((GroupNameSpec)spec2, spec1, merged);
            } else if (spec1 instanceof ModuleNameSpec) {
                this.intersect((ModuleNameSpec)spec1, spec2, merged);
            } else if (spec2 instanceof ModuleNameSpec) {
                this.intersect((ModuleNameSpec)spec2, spec1, merged);
            } else if (spec1 instanceof ModuleIdSpec && spec2 instanceof ModuleIdSpec) {
                ModuleIdSpec moduleSpec1 = (ModuleIdSpec)spec1;
                ModuleIdSpec moduleSpec2 = (ModuleIdSpec)spec2;
                if (moduleSpec1.moduleId.equals((Object)moduleSpec2.moduleId)) {
                    merged.add(moduleSpec1);
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private void intersect(GroupNameSpec spec1, ModuleVersionSpec spec2, List<ModuleVersionSpec> merged) {
            if (spec2 instanceof GroupNameSpec) {
                GroupNameSpec groupNameSpec = (GroupNameSpec)spec2;
                if (spec1.group.equals(groupNameSpec.group)) {
                    merged.add(spec1);
                }
            } else if (spec2 instanceof ModuleNameSpec) {
                ModuleNameSpec moduleNameSpec = (ModuleNameSpec)spec2;
                merged.add(new ModuleIdSpec(IvyUtil.createModuleId(spec1.group, moduleNameSpec.module)));
            } else if (spec2 instanceof ModuleIdSpec) {
                ModuleIdSpec moduleIdSpec = (ModuleIdSpec)spec2;
                if (moduleIdSpec.moduleId.getOrganisation().equals(spec1.group)) {
                    merged.add(spec2);
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private void intersect(ModuleNameSpec spec1, ModuleVersionSpec spec2, List<ModuleVersionSpec> merged) {
            if (spec2 instanceof ModuleNameSpec) {
                ModuleNameSpec moduleNameSpec = (ModuleNameSpec)spec2;
                if (spec1.module.equals(moduleNameSpec.module)) {
                    merged.add(spec1);
                }
            } else if (spec2 instanceof ModuleIdSpec) {
                ModuleIdSpec moduleIdSpec = (ModuleIdSpec)spec2;
                if (moduleIdSpec.moduleId.getName().equals(spec1.module)) {
                    merged.add(spec2);
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        protected ModuleVersionSpec doIntersection(ModuleVersionSpec other) {
            if (!(other instanceof ExcludeRuleBackedSpec)) {
                return super.doIntersection(other);
            }
            ExcludeRuleBackedSpec otherExcludeRuleSpec = (ExcludeRuleBackedSpec)other;
            HashSet<ModuleVersionSpec> allSpecs = new HashSet<ModuleVersionSpec>();
            allSpecs.addAll(this.excludeSpecs);
            allSpecs.addAll(otherExcludeRuleSpec.excludeSpecs);
            return new ExcludeRuleBackedSpec((Collection<ModuleVersionSpec>)allSpecs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CompositeSpec
    extends ModuleVersionSpec {
        private CompositeSpec() {
        }

        abstract Collection<ModuleVersionSpec> getSpecs();

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            builder.append(this.getClass().getSimpleName());
            for (ModuleVersionSpec spec : this.getSpecs()) {
                builder.append(' ');
                builder.append(spec);
            }
            builder.append("}");
            return builder.toString();
        }

        @Override
        protected boolean doAcceptsSameModulesAs(ModuleVersionSpec other) {
            CompositeSpec spec = (CompositeSpec)other;
            return this.implies(spec) && spec.implies(this);
        }

        protected boolean implies(CompositeSpec spec) {
            for (ModuleVersionSpec thisSpec : this.getSpecs()) {
                boolean found = false;
                for (ModuleVersionSpec otherSpec : spec.getSpecs()) {
                    if (!thisSpec.acceptsSameModulesAs(otherSpec)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }

    private static class AcceptAllSpec
    extends ModuleVersionSpec {
        private AcceptAllSpec() {
        }

        public String toString() {
            return "{accept-all}";
        }

        public boolean isSatisfiedBy(ModuleId element) {
            return true;
        }
    }
}

