/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.math.BigInteger;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleDescriptorCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetaDataCache;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;
import org.gradle.util.BuildCommencedTimeProvider;

class DefaultCachedMetaData
implements ModuleMetaDataCache.CachedMetaData {
    private final ModuleSource moduleSource;
    private final BigInteger descriptorHash;
    private final long ageMillis;
    private final MutableModuleVersionMetaData metaData;

    public DefaultCachedMetaData(ModuleDescriptorCacheEntry entry, MutableModuleVersionMetaData metaData, BuildCommencedTimeProvider timeProvider) {
        this.moduleSource = entry.moduleSource;
        this.descriptorHash = entry.moduleDescriptorHash;
        this.ageMillis = timeProvider.getCurrentTime() - entry.createTimestamp;
        this.metaData = metaData;
    }

    public boolean isMissing() {
        return this.metaData == null;
    }

    public ModuleSource getModuleSource() {
        return this.moduleSource;
    }

    public ResolvedModuleVersion getModuleVersion() {
        return this.isMissing() ? null : new DefaultResolvedModuleVersion(this.getMetaData().getId());
    }

    public MutableModuleVersionMetaData getMetaData() {
        return this.metaData;
    }

    public long getAgeMillis() {
        return this.ageMillis;
    }

    public BigInteger getDescriptorHash() {
        return this.descriptorHash;
    }
}

