/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.Versioned;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestStrategy;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatestVersionStrategy
implements LatestStrategy {
    private final VersionMatcher versionMatcher;

    public LatestVersionStrategy(VersionMatcher versionMatcher) {
        this.versionMatcher = versionMatcher;
    }

    @Override
    public <T extends Versioned> List<T> sort(Collection<T> versions) {
        return CollectionUtils.sort(versions, (Comparator)this);
    }

    @Override
    public <T extends Versioned> T findLatest(Collection<T> elements) {
        return (T)Collections.max(elements, this);
    }

    @Override
    public int compare(Versioned element1, Versioned element2) {
        String version1 = element1.getVersion();
        String version2 = element2.getVersion();
        if (this.versionMatcher.isDynamic(version1)) {
            int c = this.versionMatcher.compare(version1, version2);
            return c >= 0 ? 1 : -1;
        }
        if (this.versionMatcher.isDynamic(version2)) {
            int c = this.versionMatcher.compare(version2, version1);
            return c >= 0 ? -1 : 1;
        }
        return this.versionMatcher.compare(version1, version2);
    }
}

