/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionMetaData;

public class ChainVersionMatcher
implements VersionMatcher {
    private final List<VersionMatcher> matchers = Lists.newArrayList();

    public void add(VersionMatcher matcher) {
        this.matchers.add(matcher);
    }

    public boolean canHandle(String selector) {
        throw new UnsupportedOperationException("canHandle");
    }

    public boolean isDynamic(String selector) {
        return this.getCompatibleMatcher(selector).isDynamic(selector);
    }

    public boolean needModuleMetadata(String selector) {
        return this.getCompatibleMatcher(selector).needModuleMetadata(selector);
    }

    public boolean accept(String selector, String candidate) {
        return this.getCompatibleMatcher(selector).accept(selector, candidate);
    }

    public boolean accept(String selector, ModuleVersionMetaData candidate) {
        return this.getCompatibleMatcher(selector).accept(selector, candidate);
    }

    public int compare(String selector, String candidate) {
        return this.getCompatibleMatcher(selector).compare(selector, candidate);
    }

    private VersionMatcher getCompatibleMatcher(String selector) {
        for (VersionMatcher matcher : this.matchers) {
            if (!matcher.canHandle(selector)) continue;
            return matcher;
        }
        throw new IllegalArgumentException("Invalid version selector: " + selector);
    }
}

