/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.DependencyToModuleVersionResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.NewestVersionComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChain;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainDependencyResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestStrategy;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionMetaData;

public class UserResolverChain
implements RepositoryChain {
    private final RepositoryChainDependencyResolver dependencyResolver;
    private final RepositoryChainArtifactResolver artifactResolver = new RepositoryChainArtifactResolver();

    public UserResolverChain(VersionMatcher versionMatcher, LatestStrategy latestStrategy) {
        this.dependencyResolver = new RepositoryChainDependencyResolver(new NewestVersionComponentChooser(latestStrategy, versionMatcher), new ModuleTransformer());
    }

    public DependencyToModuleVersionResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void add(ModuleComponentRepository repository) {
        this.dependencyResolver.add(repository);
        this.artifactResolver.add(repository);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModuleTransformer
    implements Transformer<ModuleVersionMetaData, RepositoryChainModuleResolution> {
        private ModuleTransformer() {
        }

        public ModuleVersionMetaData transform(RepositoryChainModuleResolution original) {
            RepositoryChainModuleSource moduleSource = new RepositoryChainModuleSource(original.repository.getId(), original.moduleSource);
            return original.module.withSource(moduleSource);
        }
    }
}

