/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.component.DefaultModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.BuildableComponentResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DependencyToModuleVersionResolver;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BuildableModuleVersionMetaDataResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DefaultBuildableModuleVersionMetaDataResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DefaultBuildableModuleVersionSelectionResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryChainDependencyResolver
implements DependencyToModuleVersionResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryChainDependencyResolver.class);
    private final List<ModuleComponentRepository> repositories = new ArrayList<ModuleComponentRepository>();
    private final List<String> repositoryNames = new ArrayList<String>();
    private final ComponentChooser componentChooser;
    private final Transformer<ModuleVersionMetaData, RepositoryChainModuleResolution> metaDataFactory;

    public RepositoryChainDependencyResolver(ComponentChooser componentChooser, Transformer<ModuleVersionMetaData, RepositoryChainModuleResolution> metaDataFactory) {
        this.componentChooser = componentChooser;
        this.metaDataFactory = metaDataFactory;
    }

    public void add(ModuleComponentRepository repository) {
        this.repositories.add(repository);
        this.repositoryNames.add(repository.getName());
    }

    @Override
    public void resolve(DependencyMetaData dependency, BuildableComponentResolveResult result) {
        ModuleVersionSelector requested = dependency.getRequested();
        LOGGER.debug("Attempting to resolve module '{}' using repositories {}", (Object)requested, this.repositoryNames);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        boolean dynamicSelector = this.componentChooser.canSelectMultipleComponents(dependency.getRequested());
        ArrayList<RepositoryResolveState> resolveStates = new ArrayList<RepositoryResolveState>();
        for (ModuleComponentRepository repository : this.repositories) {
            resolveStates.add(this.createRepositoryResolveState(repository, dynamicSelector));
        }
        RepositoryChainModuleResolution latestResolved = this.findLatestModule(dependency, resolveStates, dynamicSelector, errors);
        if (latestResolved != null) {
            LOGGER.debug("Using module '{}' from repository '{}'", (Object)latestResolved.module.getId(), (Object)latestResolved.repository.getName());
            for (Throwable error : errors) {
                LOGGER.debug("Discarding resolve failure.", error);
            }
            result.resolved((ComponentMetaData)this.metaDataFactory.transform((Object)latestResolved));
            return;
        }
        if (!errors.isEmpty()) {
            result.failed(new ModuleVersionResolveException(requested, errors));
        } else {
            for (RepositoryResolveState resolveState : resolveStates) {
                resolveState.applyTo(result);
            }
            if (dynamicSelector) {
                result.notFound(requested);
            } else {
                result.notFound(DefaultModuleVersionIdentifier.newId(requested.getGroup(), requested.getName(), requested.getVersion()));
            }
        }
    }

    private RepositoryChainModuleResolution findLatestModule(DependencyMetaData dependency, List<RepositoryResolveState> resolveStates, boolean dynamicSelector, Collection<Throwable> failures) {
        LinkedList<RepositoryResolveState> queue = new LinkedList<RepositoryResolveState>();
        queue.addAll(resolveStates);
        LinkedList<RepositoryResolveState> missing = new LinkedList<RepositoryResolveState>();
        RepositoryChainModuleResolution best = this.findLatestModule(dependency, dynamicSelector, queue, failures, missing);
        if (best != null) {
            return best;
        }
        queue.addAll(missing);
        missing.clear();
        return this.findLatestModule(dependency, dynamicSelector, queue, failures, missing);
    }

    private RepositoryResolveState createRepositoryResolveState(ModuleComponentRepository repository, boolean isDynamicSelector) {
        if (isDynamicSelector) {
            return new DynamicVersionRepositoryResolveState(repository, this.componentChooser);
        }
        return new StaticVersionRepositoryResolveState(repository);
    }

    private RepositoryChainModuleResolution findLatestModule(DependencyMetaData dependency, boolean dynamicSelector, LinkedList<RepositoryResolveState> queue, Collection<Throwable> failures, Collection<RepositoryResolveState> missing) {
        boolean isStaticVersion = !dynamicSelector;
        RepositoryChainModuleResolution best = null;
        block8: while (!queue.isEmpty()) {
            RepositoryResolveState request = queue.removeFirst();
            try {
                request.resolve(dependency);
            }
            catch (Throwable t) {
                failures.add(t);
                continue;
            }
            switch (request.resolveResult.getState()) {
                case Missing: {
                    continue block8;
                }
                case ProbablyMissing: {
                    if (!request.canMakeFurtherAttempts()) continue block8;
                    missing.add(request);
                    continue block8;
                }
                case Unknown: {
                    if (!request.canMakeFurtherAttempts()) continue block8;
                    queue.addFirst(request);
                    continue block8;
                }
                case Resolved: {
                    RepositoryChainModuleResolution moduleResolution = new RepositoryChainModuleResolution(request.repository, request.resolveResult.getMetaData(), request.resolveResult.getModuleSource());
                    if (isStaticVersion && !moduleResolution.isGeneratedModuleDescriptor()) {
                        return moduleResolution;
                    }
                    best = this.chooseBest(best, moduleResolution);
                    continue block8;
                }
            }
            throw new IllegalStateException("Unexpected state for resolution: " + (Object)((Object)request.resolveResult.getState()));
        }
        return best;
    }

    private RepositoryChainModuleResolution chooseBest(RepositoryChainModuleResolution one, RepositoryChainModuleResolution two) {
        if (one == null || two == null) {
            return two == null ? one : two;
        }
        return this.componentChooser.choose(one.module, two.module) == one.module ? one : two;
    }

    private static class DynamicVersionRepositoryResolveState
    extends RepositoryResolveState {
        final DefaultBuildableModuleVersionSelectionResolveResult selectionResult = new DefaultBuildableModuleVersionSelectionResolveResult();
        private final ComponentChooser versionSelector;

        public DynamicVersionRepositoryResolveState(ModuleComponentRepository repository, ComponentChooser versionSelector) {
            super(repository);
            this.versionSelector = versionSelector;
        }

        protected void process(DependencyMetaData dependency, ModuleComponentRepositoryAccess moduleAccess, BuildableModuleVersionMetaDataResolveResult resolveResult) {
            moduleAccess.listModuleVersions(dependency, this.selectionResult);
            switch (this.selectionResult.getState()) {
                case Failed: {
                    resolveResult.failed(this.selectionResult.getFailure());
                    break;
                }
                case ProbablyListed: {
                    if (this.resolveDependency(dependency, moduleAccess, resolveResult)) break;
                    resolveResult.probablyMissing();
                    break;
                }
                case Listed: {
                    if (this.resolveDependency(dependency, moduleAccess, resolveResult)) break;
                    resolveResult.missing();
                }
            }
        }

        protected void applyTo(ResourceAwareResolveResult result) {
            this.selectionResult.applyTo(result);
            super.applyTo(result);
        }

        private boolean resolveDependency(DependencyMetaData dependency, ModuleComponentRepositoryAccess moduleAccess, BuildableModuleVersionMetaDataResolveResult resolveResult) {
            ModuleComponentIdentifier componentIdentifier = this.versionSelector.choose(this.selectionResult.getVersions(), dependency, moduleAccess);
            if (componentIdentifier == null) {
                return false;
            }
            dependency = dependency.withRequestedVersion(componentIdentifier.getVersion());
            moduleAccess.resolveComponentMetaData(dependency, componentIdentifier, resolveResult);
            return true;
        }
    }

    private class StaticVersionRepositoryResolveState
    extends RepositoryResolveState {
        public StaticVersionRepositoryResolveState(ModuleComponentRepository repository) {
            super(repository);
        }

        protected void process(DependencyMetaData dependency, ModuleComponentRepositoryAccess moduleAccess, BuildableModuleVersionMetaDataResolveResult resolveResult) {
            moduleAccess.resolveComponentMetaData(dependency, DefaultModuleComponentIdentifier.newId(dependency.getRequested().getGroup(), dependency.getRequested().getName(), dependency.getRequested().getVersion()), resolveResult);
        }
    }

    public static abstract class RepositoryResolveState {
        private final DefaultBuildableModuleVersionMetaDataResolveResult resolveResult = new DefaultBuildableModuleVersionMetaDataResolveResult();
        final ModuleComponentRepository repository;
        private boolean searchedLocally;
        boolean searchedRemotely;

        public RepositoryResolveState(ModuleComponentRepository repository) {
            this.repository = repository;
        }

        void resolve(DependencyMetaData dependency) {
            if (!this.searchedLocally) {
                this.searchedLocally = true;
                this.process(dependency, this.repository.getLocalAccess(), this.resolveResult);
            } else {
                this.searchedRemotely = true;
                this.process(dependency, this.repository.getRemoteAccess(), this.resolveResult);
            }
            if (this.resolveResult.getState() == BuildableModuleVersionMetaDataResolveResult.State.Failed) {
                throw this.resolveResult.getFailure();
            }
        }

        protected abstract void process(DependencyMetaData var1, ModuleComponentRepositoryAccess var2, BuildableModuleVersionMetaDataResolveResult var3);

        protected void applyTo(ResourceAwareResolveResult result) {
            this.resolveResult.applyTo(result);
        }

        public boolean canMakeFurtherAttempts() {
            return !this.searchedRemotely;
        }
    }
}

