/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.internal.artifacts.ivyservice.DefaultResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BuildableModuleVersionMetaDataResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;

public class DefaultBuildableModuleVersionMetaDataResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableModuleVersionMetaDataResolveResult {
    private BuildableModuleVersionMetaDataResolveResult.State state = BuildableModuleVersionMetaDataResolveResult.State.Unknown;
    private ModuleSource moduleSource;
    private ModuleVersionResolveException failure;
    private MutableModuleVersionMetaData metaData;

    private void reset(BuildableModuleVersionMetaDataResolveResult.State state) {
        this.state = state;
        this.metaData = null;
        this.failure = null;
        this.moduleSource = null;
    }

    public void reset() {
        this.reset(BuildableModuleVersionMetaDataResolveResult.State.Unknown);
    }

    public void resolved(MutableModuleVersionMetaData metaData, ModuleSource moduleSource) {
        this.reset(BuildableModuleVersionMetaDataResolveResult.State.Resolved);
        this.metaData = metaData;
        this.moduleSource = moduleSource;
    }

    public void missing() {
        this.reset(BuildableModuleVersionMetaDataResolveResult.State.Missing);
    }

    public void probablyMissing() {
        this.reset(BuildableModuleVersionMetaDataResolveResult.State.ProbablyMissing);
    }

    public void failed(ModuleVersionResolveException failure) {
        this.reset(BuildableModuleVersionMetaDataResolveResult.State.Failed);
        this.failure = failure;
    }

    public BuildableModuleVersionMetaDataResolveResult.State getState() {
        return this.state;
    }

    public boolean hasResult() {
        return this.state != BuildableModuleVersionMetaDataResolveResult.State.Unknown;
    }

    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    public MutableModuleVersionMetaData getMetaData() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metaData;
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }

    private void assertResolved() {
        if (this.state == BuildableModuleVersionMetaDataResolveResult.State.Failed) {
            throw this.failure;
        }
        if (this.state != BuildableModuleVersionMetaDataResolveResult.State.Resolved) {
            throw new IllegalStateException("This module has not been resolved.");
        }
    }

    public ModuleSource getModuleSource() {
        this.assertResolved();
        return this.moduleSource;
    }

    public void setModuleSource(ModuleSource moduleSource) {
        this.assertResolved();
        this.moduleSource = moduleSource;
    }
}

