/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.clientmodule;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.ivyservice.BuildableComponentResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DependencyToModuleVersionResolver;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.EnhancedDependencyDescriptor;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.DefaultDependencyMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;
import org.gradle.internal.Transformers;

public class ClientModuleResolver
implements DependencyToModuleVersionResolver {
    private final DependencyToModuleVersionResolver resolver;
    private final DependencyDescriptorFactory dependencyDescriptorFactory;
    private final Transformer<MutableModuleVersionMetaData, ComponentMetaData> toModuleVersionMetaData = Transformers.cast(MutableModuleVersionMetaData.class);

    public ClientModuleResolver(DependencyToModuleVersionResolver resolver, DependencyDescriptorFactory dependencyDescriptorFactory) {
        this.resolver = resolver;
        this.dependencyDescriptorFactory = dependencyDescriptorFactory;
    }

    public void resolve(DependencyMetaData dependency, BuildableComponentResolveResult result) {
        ModuleDependency maybeClientModule;
        this.resolver.resolve(dependency, result);
        if (result.getFailure() != null) {
            return;
        }
        DependencyDescriptor descriptor = dependency.getDescriptor();
        if (descriptor instanceof EnhancedDependencyDescriptor && (maybeClientModule = ((EnhancedDependencyDescriptor)descriptor).getModuleDependency()) instanceof ClientModule) {
            ClientModule clientModule = (ClientModule)maybeClientModule;
            MutableModuleVersionMetaData clientModuleMetaData = ((MutableModuleVersionMetaData)this.toModuleVersionMetaData.transform((Object)result.getMetaData())).copy();
            this.addClientModuleDependencies(clientModule, clientModuleMetaData);
            this.setClientModuleArtifact(clientModuleMetaData);
            result.setMetaData(clientModuleMetaData);
        }
    }

    private void addClientModuleDependencies(ClientModule clientModule, MutableModuleVersionMetaData clientModuleMetaData) {
        ArrayList dependencies = Lists.newArrayList();
        for (ModuleDependency moduleDependency : clientModule.getDependencies()) {
            DependencyDescriptor dependencyDescriptor = this.dependencyDescriptorFactory.createDependencyDescriptor(moduleDependency.getConfiguration(), clientModuleMetaData.getDescriptor(), moduleDependency);
            dependencies.add(new DefaultDependencyMetaData(dependencyDescriptor));
        }
        clientModuleMetaData.setDependencies(dependencies);
    }

    private void setClientModuleArtifact(MutableModuleVersionMetaData clientModuleMetaData) {
        ModuleVersionArtifactMetaData artifact = clientModuleMetaData.artifact("jar", "jar", null);
        clientModuleMetaData.setArtifacts(Sets.newHashSet((Object[])new ModuleVersionArtifactMetaData[]{artifact}));
    }
}

