/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.messaging.serialize.Serializer;
import org.gradle.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheLockingManager
implements CacheLockingManager {
    public static final VersionNumber CACHE_LAYOUT_VERSION = CacheLayout.META_DATA.getVersion();
    private final PersistentCache cache;

    public DefaultCacheLockingManager(CacheRepository cacheRepository) {
        this.cache = cacheRepository.store(CacheLayout.ROOT.getKey()).withCrossVersionCache().withDisplayName("artifact cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
    }

    public void close() {
        this.cache.close();
    }

    @Override
    public File getCacheDir() {
        return this.cache.getBaseDir();
    }

    public void longRunningOperation(String operationDisplayName, Runnable action) {
        this.cache.longRunningOperation(operationDisplayName, action);
    }

    public <T> T useCache(String operationDisplayName, Factory<? extends T> action) {
        return (T)this.cache.useCache(operationDisplayName, action);
    }

    public void useCache(String operationDisplayName, Runnable action) {
        this.cache.useCache(operationDisplayName, action);
    }

    public <T> T longRunningOperation(String operationDisplayName, Factory<? extends T> action) {
        return (T)this.cache.longRunningOperation(operationDisplayName, action);
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        String cacheFileInMetaDataStore = CacheLayout.META_DATA.getKey() + "/" + cacheName;
        return this.cache.createCache(new PersistentIndexedCacheParameters(cacheFileInMetaDataStore, keySerializer, valueSerializer));
    }

    @Override
    public File getFileStoreDirectory() {
        return this.createCacheRelativeDir(CacheLayout.FILE_STORE);
    }

    @Override
    public File createMetaDataStore() {
        return new File(this.createCacheRelativeDir(CacheLayout.META_DATA), "descriptors");
    }

    private File createCacheRelativeDir(CacheLayout cacheLayout) {
        return cacheLayout.getPath(this.cache.getBaseDir());
    }
}

