/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.BuildableComponentResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionNotFoundException;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;

public class DefaultBuildableComponentResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableComponentResolveResult {
    private ComponentMetaData metaData;
    private ModuleVersionResolveException failure;

    public DefaultBuildableComponentResolveResult failed(ModuleVersionResolveException failure) {
        this.metaData = null;
        this.failure = failure;
        return this;
    }

    public void notFound(ModuleVersionSelector versionSelector) {
        this.failed(new ModuleVersionNotFoundException(versionSelector, this.getAttempted()));
    }

    public void notFound(ModuleVersionIdentifier versionIdentifier) {
        this.failed(new ModuleVersionNotFoundException(versionIdentifier, this.getAttempted()));
    }

    public void resolved(ComponentMetaData metaData) {
        this.metaData = metaData;
    }

    public void setMetaData(ComponentMetaData metaData) {
        this.assertResolved();
        this.metaData = metaData;
    }

    public ModuleVersionIdentifier getId() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metaData.getId();
    }

    public ComponentMetaData getMetaData() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metaData;
    }

    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    private void assertResolved() {
        this.assertHasResult();
        if (this.failure != null) {
            throw this.failure;
        }
    }

    private void assertHasResult() {
        if (this.failure == null && this.metaData == null) {
            throw new IllegalStateException("No result has been specified.");
        }
    }
}

