/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import org.apache.ivy.Ivy;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactSetResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ComponentUsage;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextManager;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.component.ArtifactType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextualArtifactResolver
implements ArtifactResolver {
    private final CacheLockingManager lockingManager;
    private final IvyContextManager ivyContextManager;
    private final ArtifactResolver delegate;

    public ContextualArtifactResolver(CacheLockingManager lockingManager, IvyContextManager ivyContextManager, ArtifactResolver delegate) {
        this.lockingManager = lockingManager;
        this.ivyContextManager = ivyContextManager;
        this.delegate = delegate;
    }

    @Override
    public void resolveModuleArtifacts(final ComponentMetaData component, final ArtifactType artifactType, final BuildableArtifactSetResolveResult result) {
        this.executeInContext(String.format("Resolve %s for %s", artifactType, component), new Action<Ivy>(){

            public void execute(Ivy ivy) {
                ContextualArtifactResolver.this.delegate.resolveModuleArtifacts(component, artifactType, result);
            }
        });
    }

    @Override
    public void resolveModuleArtifacts(final ComponentMetaData component, final ComponentUsage usage, final BuildableArtifactSetResolveResult result) {
        this.executeInContext(String.format("Resolve %s for %s", usage, component), new Action<Ivy>(){

            public void execute(Ivy ivy) {
                ContextualArtifactResolver.this.delegate.resolveModuleArtifacts(component, usage, result);
            }
        });
    }

    @Override
    public void resolveArtifact(final ComponentArtifactMetaData artifact, final ModuleSource moduleSource, final BuildableArtifactResolveResult result) {
        this.executeInContext(String.format("Resolve %s", artifact), new Action<Ivy>(){

            public void execute(Ivy ivy) {
                ContextualArtifactResolver.this.delegate.resolveArtifact(artifact, moduleSource, result);
            }
        });
    }

    private void executeInContext(String description, final Action<Ivy> action) {
        this.lockingManager.useCache(description, new Runnable(){

            public void run() {
                ContextualArtifactResolver.this.ivyContextManager.withIvy((Action<? super Ivy>)action);
            }
        });
    }
}

