/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import java.util.Collection;
import org.apache.tools.ant.Task;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.ArtifactFile;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationParser;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypedNotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishArtifactNotationParserFactory
implements Factory<NotationParser<Object, PublishArtifact>> {
    private final Instantiator instantiator;
    private final DependencyMetaDataProvider metaDataProvider;

    public PublishArtifactNotationParserFactory(Instantiator instantiator, DependencyMetaDataProvider metaDataProvider) {
        this.instantiator = instantiator;
        this.metaDataProvider = metaDataProvider;
    }

    public NotationParser<Object, PublishArtifact> create() {
        FileNotationParser fileParser = new FileNotationParser();
        return NotationParserBuilder.toType(PublishArtifact.class).parser((NotationParser)new ArchiveTaskNotationParser()).parser((NotationParser)new FileMapNotationParser(fileParser)).parser((NotationParser)fileParser).toComposite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileNotationParser
    extends TypedNotationParser<File, PublishArtifact> {
        private FileNotationParser() {
            super(File.class);
        }

        protected PublishArtifact parseType(File file) {
            ModuleInternal module = PublishArtifactNotationParserFactory.this.metaDataProvider.getModule();
            ArtifactFile artifactFile = new ArtifactFile(file, module.getVersion());
            return (PublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(DefaultPublishArtifact.class, new Object[]{artifactFile.getName(), artifactFile.getExtension(), artifactFile.getExtension() == null ? "" : artifactFile.getExtension(), artifactFile.getClassifier(), null, file, new Task[0]});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileMapNotationParser
    extends MapNotationParser<PublishArtifact> {
        private final FileNotationParser fileParser;

        private FileMapNotationParser(FileNotationParser fileParser) {
            this.fileParser = fileParser;
        }

        protected PublishArtifact parseMap(@MapKey(value="file") File file) {
            return this.fileParser.parseType(file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArchiveTaskNotationParser
    extends TypedNotationParser<AbstractArchiveTask, PublishArtifact> {
        private ArchiveTaskNotationParser() {
            super(AbstractArchiveTask.class);
        }

        public void describe(Collection<String> candidateFormats) {
            candidateFormats.add("Instances of AbstractArchiveTask, e.g. jar.");
        }

        protected PublishArtifact parseType(AbstractArchiveTask notation) {
            return (PublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(ArchivePublishArtifact.class, new Object[]{notation});
        }
    }
}

