/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.IvyModuleMetadata;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.gradle.api.internal.artifacts.ModuleMetadataProcessor;
import org.gradle.api.internal.artifacts.ivyservice.DefaultIvyModuleMetadata;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.metadata.IvyModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionMetaData;
import org.gradle.api.internal.artifacts.repositories.resolver.ComponentMetadataDetailsAdapter;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.listener.ActionBroadcast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentMetadataHandler
implements ComponentMetadataHandler,
ModuleMetadataProcessor {
    private final Instantiator instantiator;
    private final ActionBroadcast<ComponentMetadataDetails> ruleActions = new ActionBroadcast();
    private final List<Closure<?>> ruleClosures = Lists.newArrayList();

    public DefaultComponentMetadataHandler(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void eachComponent(Action<? super ComponentMetadataDetails> rule) {
        this.ruleActions.add(rule);
    }

    public void eachComponent(Closure<?> closure) {
        this.ruleClosures.add(closure);
    }

    @Override
    public void process(ModuleVersionMetaData metadata) {
        ComponentMetadataDetails details = (ComponentMetadataDetails)this.instantiator.newInstance(ComponentMetadataDetailsAdapter.class, new Object[]{metadata});
        this.ruleActions.execute((Object)details);
        this.executeRuleClosures(metadata, details);
        if (!metadata.getStatusScheme().contains(metadata.getStatus())) {
            throw new ModuleVersionResolveException(metadata.getId(), "Unexpected status '" + metadata.getStatus() + "' specified for %s. Expected one of: " + metadata.getStatusScheme());
        }
    }

    private void executeRuleClosures(ModuleVersionMetaData metadata, ComponentMetadataDetails details) {
        for (Closure<?> closure : this.ruleClosures) {
            this.executeRuleClosure(metadata, details, closure);
        }
    }

    private void executeRuleClosure(ModuleVersionMetaData metadata, ComponentMetadataDetails details, Closure<?> closure) {
        ArrayList args = Lists.newArrayList();
        for (Class argType : closure.getParameterTypes()) {
            if (argType == ComponentMetadataDetails.class || argType == Object.class) {
                args.add(details);
                continue;
            }
            if (argType == IvyModuleMetadata.class) {
                if (!(metadata instanceof IvyModuleVersionMetaData)) {
                    return;
                }
                args.add(new DefaultIvyModuleMetadata(((IvyModuleVersionMetaData)metadata).getExtraInfo()));
                continue;
            }
            throw new GradleException(String.format("Unsupported parameter type for component metadata rule: %s", argType.getName()));
        }
        closure.call(args.toArray());
    }
}

