/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.component;

import org.gradle.api.artifacts.component.ProjectComponentIdentifier;

public class DefaultProjectComponentIdentifier
implements ProjectComponentIdentifier {
    private final String projectPath;
    private final String displayName;

    public DefaultProjectComponentIdentifier(String projectPath) {
        assert (projectPath != null) : "project path cannot be null";
        this.projectPath = projectPath;
        this.displayName = String.format("project %s", projectPath);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectComponentIdentifier that = (DefaultProjectComponentIdentifier)o;
        return this.projectPath.equals(that.projectPath);
    }

    public int hashCode() {
        return this.projectPath.hashCode();
    }

    public String toString() {
        return this.displayName;
    }

    public static ProjectComponentIdentifier newId(String projectPath) {
        return new DefaultProjectComponentIdentifier(projectPath);
    }
}

